/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.NavigableSet;
import org.jsimpledb.util.ConvertedNavigableSet;

class NavigableSetConverter<E, W>
extends Converter<NavigableSet<E>, NavigableSet<W>> {
    private final Converter<E, W> elementConverter;

    NavigableSetConverter(Converter<E, W> elementConverter) {
        Preconditions.checkArgument((elementConverter != null ? 1 : 0) != 0, (Object)"null elementConverter");
        this.elementConverter = elementConverter;
    }

    protected NavigableSet<W> doForward(NavigableSet<E> set) {
        if (set == null) {
            return null;
        }
        return new ConvertedNavigableSet(set, this.elementConverter.reverse());
    }

    protected NavigableSet<E> doBackward(NavigableSet<W> set) {
        if (set == null) {
            return null;
        }
        return new ConvertedNavigableSet(set, this.elementConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        NavigableSetConverter that = (NavigableSetConverter)((Object)obj);
        return this.elementConverter.equals(that.elementConverter);
    }

    public int hashCode() {
        return this.elementConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[elementConverter=" + this.elementConverter + "]";
    }
}

