/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JObject;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.OnVersionChange;

class OnVersionChangeScanner<T>
extends AnnotationScanner<T, OnVersionChange>
implements Comparator<MethodAnnotationScanner.MethodInfo> {
    private final TypeToken<Map<Integer, Object>> byStorageIdType = new TypeToken<Map<Integer, Object>>(){};
    private final TypeToken<Map<String, Object>> byNameType = new TypeToken<Map<String, Object>>(){};

    OnVersionChangeScanner(JClass<T> jclass) {
        super(jclass, OnVersionChange.class);
    }

    protected boolean includeMethod(Method method, OnVersionChange annotation) {
        if (annotation.oldVersion() < 0) {
            throw new IllegalArgumentException("@" + this.annotationType.getSimpleName() + " has illegal negative oldVersion");
        }
        if (annotation.newVersion() < 0) {
            throw new IllegalArgumentException("@" + this.annotationType.getSimpleName() + " has illegal negative newVersion");
        }
        this.checkNotStatic(method);
        this.checkReturnType(method, Void.TYPE);
        int index = 0;
        if (annotation.oldVersion() == 0) {
            this.checkParameterType(method, index++, TypeToken.of(Integer.TYPE));
        }
        if (annotation.newVersion() == 0) {
            this.checkParameterType(method, index++, TypeToken.of(Integer.TYPE));
        }
        ArrayList choices = new ArrayList(2);
        choices.add(this.byStorageIdType);
        choices.add(this.byNameType);
        this.checkParameterType(method, index, choices);
        return true;
    }

    protected VersionChangeMethodInfo createMethodInfo(Method method, OnVersionChange annotation) {
        return new VersionChangeMethodInfo(method, annotation);
    }

    @Override
    public int compare(MethodAnnotationScanner.MethodInfo info1, MethodAnnotationScanner.MethodInfo info2) {
        OnVersionChange annotation1 = (OnVersionChange)info1.getAnnotation();
        OnVersionChange annotation2 = (OnVersionChange)info2.getAnnotation();
        int diff = Boolean.compare(annotation1.oldVersion() == 0, annotation2.oldVersion() == 0);
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(annotation1.newVersion() == 0, annotation2.newVersion() == 0);
        if (diff != 0) {
            return diff;
        }
        diff = info1.getMethod().getName().compareTo(info2.getMethod().getName());
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    class VersionChangeMethodInfo
    extends MethodAnnotationScanner.MethodInfo {
        private final boolean byName;

        VersionChangeMethodInfo(Method method, OnVersionChange annotation) {
            super((MethodAnnotationScanner)OnVersionChangeScanner.this, method, (Annotation)annotation);
            List<TypeToken<?>> actuals = OnVersionChangeScanner.this.getParameterTypeTokens(method);
            TypeToken<?> oldValuesType = actuals.get(actuals.size() - 1);
            if (oldValuesType.equals((Object)OnVersionChangeScanner.this.byStorageIdType)) {
                this.byName = false;
            } else if (oldValuesType.equals((Object)OnVersionChangeScanner.this.byNameType)) {
                this.byName = true;
            } else {
                throw new RuntimeException("internal error");
            }
        }

        void invoke(JObject jobj, int oldVersion, int newVersion, Map<Integer, Object> oldValuesByStorageId, Map<String, Object> oldValuesByName) {
            OnVersionChange annotation = (OnVersionChange)this.getAnnotation();
            Method method = this.getMethod();
            if (annotation.oldVersion() != 0 && annotation.oldVersion() != oldVersion || annotation.newVersion() != 0 && annotation.newVersion() != newVersion) {
                return;
            }
            Map<Object, Object> oldValues = this.byName ? oldValuesByName : oldValuesByStorageId;
            switch ((annotation.oldVersion() != 0 ? 2 : 0) + (annotation.newVersion() != 0 ? 1 : 0)) {
                case 0: {
                    Util.invoke(method, jobj, oldVersion, newVersion, oldValues);
                    break;
                }
                case 1: {
                    Util.invoke(method, jobj, oldVersion, oldValues);
                    break;
                }
                case 2: {
                    Util.invoke(method, jobj, newVersion, oldValues);
                    break;
                }
                default: {
                    Util.invoke(method, jobj, oldValues);
                }
            }
        }
    }
}

