/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.SessionMode;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.schema.NameIndex;
import org.jsimpledb.schema.SchemaModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KVDatabase kvdb;
    private final JSimpleDB jdb;
    private final Database db;
    private SessionMode mode;
    private SchemaModel schemaModel;
    private ValidationMode validationMode;
    private NameIndex nameIndex;
    private String databaseDescription;
    private int schemaVersion;
    private boolean allowNewSchema;
    private boolean readOnly;
    private KVTransaction kvt;
    private Transaction tx;
    private boolean rollbackOnly;

    public Session(KVDatabase kvdb) {
        this(null, null, kvdb);
    }

    public Session(Database db) {
        this(null, db, db != null ? db.getKVDatabase() : null);
    }

    public Session(JSimpleDB jdb) {
        this(jdb, jdb != null ? jdb.getDatabase() : null, jdb != null ? jdb.getDatabase().getKVDatabase() : null);
    }

    private Session(JSimpleDB jdb, Database db, KVDatabase kvdb) {
        Preconditions.checkArgument((kvdb != null ? 1 : 0) != 0, (Object)"null kvdb");
        if (jdb != null) {
            Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"null db");
            this.mode = SessionMode.JSIMPLEDB;
        } else {
            this.mode = db != null ? SessionMode.CORE_API : SessionMode.KEY_VALUE;
        }
        this.jdb = jdb;
        this.db = db;
        this.kvdb = kvdb;
    }

    public SessionMode getMode() {
        return this.mode;
    }

    public void setMode(SessionMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"null mode");
        switch (mode) {
            case KEY_VALUE: {
                break;
            }
            case CORE_API: {
                Preconditions.checkArgument((this.db != null ? 1 : 0) != 0, (Object)"session is not configured with a Core API Database instance");
                break;
            }
            case JSIMPLEDB: {
                Preconditions.checkArgument((this.jdb != null ? 1 : 0) != 0, (Object)"session is not configured with a JSimpleDB instance");
                break;
            }
            default: {
                throw new IllegalArgumentException("internal error");
            }
        }
        this.mode = mode;
    }

    public KVDatabase getKVDatabase() {
        return this.kvdb;
    }

    public Database getDatabase() {
        return this.db;
    }

    public JSimpleDB getJSimpleDB() {
        return this.jdb;
    }

    public KVTransaction getKVTransaction() {
        Preconditions.checkState((this.kvt != null ? 1 : 0) != 0, (Object)"no transaction is currently associated with this session");
        return this.kvt;
    }

    public Transaction getTransaction() {
        Preconditions.checkState((boolean)this.mode.hasCoreAPI(), (Object)("core API not available in " + (Object)((Object)this.mode) + " mode"));
        Preconditions.checkState((this.tx != null ? 1 : 0) != 0, (Object)"no transaction is currently associated with this session");
        return this.tx;
    }

    public JTransaction getJTransaction() {
        Preconditions.checkState((boolean)this.mode.hasJSimpleDB(), (Object)("JSimpleDB not available in " + (Object)((Object)this.mode) + " mode"));
        return JTransaction.getCurrent();
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public void setSchemaModel(SchemaModel schemaModel) {
        this.schemaModel = schemaModel;
        this.nameIndex = this.schemaModel != null ? new NameIndex(this.schemaModel) : null;
    }

    public NameIndex getNameIndex() {
        return this.nameIndex != null ? this.nameIndex : new NameIndex(new SchemaModel());
    }

    public String getDatabaseDescription() {
        return this.databaseDescription;
    }

    public void setDatabaseDescription(String databaseDescription) {
        this.databaseDescription = databaseDescription;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public boolean isAllowNewSchema() {
        return this.allowNewSchema;
    }

    public void setAllowNewSchema(boolean allowNewSchema) {
        this.allowNewSchema = allowNewSchema;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void reportException(Exception e) {
        this.log.error("exception within session", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performSessionActionWithCurrentTransaction(Action action) {
        boolean associate;
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        Preconditions.checkArgument((boolean)SessionMode.JSIMPLEDB.equals((Object)this.mode), (Object)"session is not in JSimpleDB mode");
        Transaction currentTx = JTransaction.getCurrent().getTransaction();
        KVTransaction currentKVT = currentTx.getKVTransaction();
        if (this.tx == null && this.kvt == null) {
            associate = true;
        } else if (this.tx == currentTx && this.kvt == currentKVT) {
            associate = false;
        } else {
            throw new IllegalStateException("a different transaction is already open in this session");
        }
        if (associate) {
            this.tx = currentTx;
            this.kvt = currentKVT;
        }
        try {
            action.run(this);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.reportException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (associate) {
                this.tx = null;
                this.kvt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performSessionAction(Action action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        if (this.kvt != null || !(action instanceof TransactionalAction)) {
            try {
                action.run(this);
                return true;
            }
            catch (Exception e) {
                this.reportException(e);
                return false;
            }
        }
        try {
            boolean bl;
            if (!this.openTransaction()) {
                boolean e = false;
                return e;
            }
            boolean success = false;
            this.rollbackOnly = false;
            try {
                action.run(this);
                success = true;
                bl = success && !this.rollbackOnly;
            }
            catch (Throwable throwable) {
                success &= this.closeTransaction(success && !this.rollbackOnly);
                throw throwable;
            }
            boolean bl2 = success &= this.closeTransaction(bl);
            return bl2;
        }
        catch (Exception e) {
            this.reportException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tx = null;
        }
    }

    public boolean isTransactionOpen() {
        return this.kvt != null;
    }

    public void setRollbackOnly() {
        Preconditions.checkState((this.kvt != null ? 1 : 0) != 0, (Object)"no transaction is open in this session");
        this.rollbackOnly = true;
    }

    private boolean openTransaction() {
        try {
            Preconditions.checkState((this.tx == null && this.kvt == null ? 1 : 0) != 0, (Object)"a transaction is already open in this session");
            switch (this.mode) {
                case KEY_VALUE: {
                    this.kvt = this.kvdb.createTransaction();
                    break;
                }
                case CORE_API: {
                    this.tx = this.db.createTransaction(this.schemaModel, this.schemaVersion, this.allowNewSchema);
                    this.kvt = this.tx.getKVTransaction();
                    break;
                }
                case JSIMPLEDB: {
                    Preconditions.checkState((!Session.isCurrentJTransaction() ? 1 : 0) != 0, (Object)"a JSimpleDB transaction is already open in the current thread");
                    JTransaction jtx = this.jdb.createTransaction(this.allowNewSchema, this.validationMode != null ? this.validationMode : ValidationMode.AUTOMATIC);
                    JTransaction.setCurrent(jtx);
                    this.tx = jtx.getTransaction();
                    this.kvt = this.tx.getKVTransaction();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.tx != null) {
                Schema schema = this.tx.getSchema();
                this.setSchemaModel(schema.getSchemaModel());
                this.setSchemaVersion(schema.getVersionNumber());
                this.tx.setReadOnly(this.readOnly);
            }
            return true;
        }
        catch (Exception e) {
            this.tx = null;
            this.kvt = null;
            this.reportException(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeTransaction(boolean commit) {
        SessionMode currentMode = this.mode;
        try {
            Preconditions.checkState((this.tx != null || this.kvt != null ? 1 : 0) != 0, (Object)"no transaction");
            switch (currentMode) {
                case JSIMPLEDB: {
                    if (commit && !this.tx.isRollbackOnly()) {
                        JTransaction.getCurrent().commit();
                        break;
                    }
                    JTransaction.getCurrent().rollback();
                    break;
                }
                case CORE_API: {
                    if (commit && !this.tx.isRollbackOnly()) {
                        this.tx.commit();
                        break;
                    }
                    this.tx.rollback();
                    break;
                }
                case KEY_VALUE: {
                    if (commit) {
                        this.kvt.commit();
                        break;
                    }
                    this.kvt.rollback();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.reportException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            switch (currentMode) {
                case JSIMPLEDB: {
                    JTransaction.setCurrent(null);
                }
                case CORE_API: {
                    this.tx = null;
                }
                case KEY_VALUE: {
                    this.kvt = null;
                }
            }
        }
    }

    private static boolean isCurrentJTransaction() {
        try {
            JTransaction.getCurrent();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static interface TransactionalAction
    extends Action {
    }

    public static interface Action {
        public void run(Session var1) throws Exception;
    }
}

