/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import com.google.common.base.Preconditions;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;

public abstract class Change<T> {
    private final T jobj;

    protected Change(T jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        this.jobj = jobj;
    }

    public T getObject() {
        return this.jobj;
    }

    public JObject getJObject() {
        return (JObject)this.jobj;
    }

    public abstract <R> R visit(ChangeSwitch<R> var1);

    public abstract void apply(JTransaction var1, JObject var2);

    public void apply(JTransaction jtx) {
        Preconditions.checkArgument((jtx != null ? 1 : 0) != 0, (Object)"null jtx");
        this.apply(jtx, this.getJObject());
    }

    public void apply() {
        this.apply(JTransaction.getCurrent());
    }

    public void apply(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        this.apply(jobj.getTransaction(), jobj);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Change that = (Change)obj;
        return this.jobj.equals(that.jobj);
    }

    public int hashCode() {
        return this.jobj.hashCode();
    }
}

