/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import com.google.common.base.Preconditions;
import org.jsimpledb.CopyState;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.Change;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.ListFieldAdd;
import org.jsimpledb.change.ListFieldClear;
import org.jsimpledb.change.ListFieldRemove;
import org.jsimpledb.change.ListFieldReplace;
import org.jsimpledb.change.MapFieldAdd;
import org.jsimpledb.change.MapFieldClear;
import org.jsimpledb.change.MapFieldRemove;
import org.jsimpledb.change.MapFieldReplace;
import org.jsimpledb.change.ObjectCreate;
import org.jsimpledb.change.ObjectDelete;
import org.jsimpledb.change.SetFieldAdd;
import org.jsimpledb.change.SetFieldClear;
import org.jsimpledb.change.SetFieldRemove;
import org.jsimpledb.change.SimpleFieldChange;

public class ChangeCopier
implements ChangeSwitch<Change<?>> {
    protected final JTransaction dest;
    protected final CopyState copyState = new CopyState();

    public ChangeCopier(JTransaction dest) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        this.dest = dest;
    }

    public ChangeCopier() {
        this(JTransaction.getCurrent().getSnapshotTransaction());
    }

    public JTransaction getDestinationTransaction() {
        return this.dest;
    }

    public CopyState getCopyState() {
        return this.copyState;
    }

    @Override
    public <T> ObjectCreate<T> caseObjectCreate(ObjectCreate<T> change) {
        return new ObjectCreate(this.copyIfReference(change.getObject()));
    }

    @Override
    public <T> ObjectDelete<T> caseObjectDelete(ObjectDelete<T> change) {
        return new ObjectDelete(this.copyIfReference(change.getObject()));
    }

    @Override
    public <T, E> ListFieldAdd<T, E> caseListFieldAdd(ListFieldAdd<T, E> change) {
        return new ListFieldAdd(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), change.getIndex(), this.copyIfReference(change.getElement()));
    }

    @Override
    public <T> ListFieldClear<T> caseListFieldClear(ListFieldClear<T> change) {
        return new ListFieldClear(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName());
    }

    @Override
    public <T, E> ListFieldRemove<T, E> caseListFieldRemove(ListFieldRemove<T, E> change) {
        return new ListFieldRemove(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), change.getIndex(), this.copyIfReference(change.getElement()));
    }

    @Override
    public <T, E> ListFieldReplace<T, E> caseListFieldReplace(ListFieldReplace<T, E> change) {
        return new ListFieldReplace(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), change.getIndex(), this.copyIfReference(change.getOldValue()), this.copyIfReference(change.getNewValue()));
    }

    @Override
    public <T, K, V> MapFieldAdd<T, K, V> caseMapFieldAdd(MapFieldAdd<T, K, V> change) {
        return new MapFieldAdd(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getKey()), this.copyIfReference(change.getValue()));
    }

    @Override
    public <T> MapFieldClear<T> caseMapFieldClear(MapFieldClear<T> change) {
        return new MapFieldClear(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName());
    }

    @Override
    public <T, K, V> MapFieldRemove<T, K, V> caseMapFieldRemove(MapFieldRemove<T, K, V> change) {
        return new MapFieldRemove(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getKey()), this.copyIfReference(change.getValue()));
    }

    @Override
    public <T, K, V> MapFieldReplace<T, K, V> caseMapFieldReplace(MapFieldReplace<T, K, V> change) {
        return new MapFieldReplace(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getKey()), this.copyIfReference(change.getOldValue()), this.copyIfReference(change.getNewValue()));
    }

    @Override
    public <T, E> SetFieldAdd<T, E> caseSetFieldAdd(SetFieldAdd<T, E> change) {
        return new SetFieldAdd(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getElement()));
    }

    @Override
    public <T> SetFieldClear<T> caseSetFieldClear(SetFieldClear<T> change) {
        return new SetFieldClear(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName());
    }

    @Override
    public <T, E> SetFieldRemove<T, E> caseSetFieldRemove(SetFieldRemove<T, E> change) {
        return new SetFieldRemove(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getElement()));
    }

    @Override
    public <T, V> SimpleFieldChange<T, V> caseSimpleFieldChange(SimpleFieldChange<T, V> change) {
        return new SimpleFieldChange(this.copyIfReference(change.getObject()), change.getStorageId(), change.getFieldName(), this.copyIfReference(change.getOldValue()), this.copyIfReference(change.getNewValue()));
    }

    private <T> T copyIfReference(T obj) {
        return (T)(obj instanceof JObject ? this.copy((JObject)obj) : obj);
    }

    protected JObject copy(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return !jobj.exists() ? this.dest.get(jobj) : jobj.copyTo(this.dest, null, this.getCopyState(), new String[0]);
    }
}

