/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.ListFieldChange;

public class ListFieldAdd<T, E>
extends ListFieldChange<T> {
    private final int index;
    private final E element;

    public ListFieldAdd(T jobj, int storageId, String fieldName, int index, E element) {
        super(jobj, storageId, fieldName);
        this.index = index;
        this.element = element;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseListFieldAdd(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readListField(jobj.getObjId(), this.getStorageId(), false).add(this.index, this.element);
    }

    public int getIndex() {
        return this.index;
    }

    public E getElement() {
        return this.element;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ListFieldAdd that = (ListFieldAdd)obj;
        return this.index == that.index && (this.element != null ? this.element.equals(that.element) : that.element == null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.index ^ (this.element != null ? this.element.hashCode() : 0);
    }

    public String toString() {
        return "ListFieldAdd[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",index=" + this.index + ",element=" + this.element + "]";
    }
}

