/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.annotation.JTransient;

abstract class AbstractFieldScanner<T, A extends Annotation>
extends AnnotationScanner<T, A> {
    protected final boolean autogenFields;
    protected final boolean autogenNonAbstract;

    AbstractFieldScanner(JClass<T> jclass, Class<A> annotationType, boolean autogenFields, boolean autogenNonAbstract) {
        super(jclass, annotationType);
        this.autogenFields = autogenFields;
        this.autogenNonAbstract = autogenNonAbstract;
    }

    protected abstract A getDefaultAnnotation();

    protected A getAnnotation(Method method) {
        Annotation annotation = super.getAnnotation(method);
        if (annotation != null) {
            return (A)annotation;
        }
        if (this.isAutoPropertyCandidate(method)) {
            return this.getDefaultAnnotation();
        }
        return null;
    }

    protected boolean isAutoPropertyCandidate(Method method) {
        if (!this.autogenFields) {
            return false;
        }
        if ((method.getModifiers() & 8) != 0) {
            return false;
        }
        if (this.hasJTransientAnnotation(method)) {
            return false;
        }
        if (!this.autogenNonAbstract && this.isOverriddenByConcreteMethod(method)) {
            return false;
        }
        if ((method.getModifiers() & 5) == 0) {
            return false;
        }
        if ((method.getModifiers() & 2) != 0) {
            return false;
        }
        if (!Pattern.compile("(is|get)(.+)").matcher(method.getName()).matches()) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != Void.TYPE;
    }

    private boolean isOverriddenByConcreteMethod(Method method) {
        if ((method.getModifiers() & 0x400) == 0) {
            return true;
        }
        Class<?> methodType = method.getDeclaringClass();
        for (TypeToken typeToken : TypeToken.of(this.jclass.type).getTypes()) {
            Method otherMethod;
            Class type = typeToken.getRawType();
            if (!methodType.isAssignableFrom(type) || type.equals(methodType)) continue;
            try {
                otherMethod = type.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if ((otherMethod.getModifiers() & 0x400) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasJTransientAnnotation(Method method) {
        String name = method.getName();
        Class<?>[] ptypes = method.getParameterTypes();
        for (TypeToken typeToken : TypeToken.of(method.getDeclaringClass()).getTypes()) {
            Method override;
            try {
                override = typeToken.getRawType().getDeclaredMethod(name, ptypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (override.getAnnotation(JTransient.class) == null) continue;
            return true;
        }
        return false;
    }
}

