/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.CopyState;
import org.jsimpledb.EnumConverter;
import org.jsimpledb.JClass;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.FieldVisitor;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.DatabaseException;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassGenerator<T> {
    static final String GEN_SOURCE = "[GeneratedByJSimpleDB]";
    static final String TX_FIELD_NAME = "$tx";
    static final String ID_FIELD_NAME = "$id";
    static final String JFIELD_FIELD_PREFIX = "$f";
    static final String ENUM_CONVERTER_FIELD_PREFIX = "$ec";
    static final Method JOBJECT_GET_OBJ_ID_METHOD;
    static final Method JOBJECT_GET_SCHEMA_VERSION_METHOD;
    static final Method JOBJECT_GET_TRANSACTION;
    static final Method JOBJECT_DELETE_METHOD;
    static final Method JOBJECT_EXISTS_METHOD;
    static final Method JOBJECT_IS_SNAPSHOT_METHOD;
    static final Method JOBJECT_RECREATE_METHOD;
    static final Method JOBJECT_UPGRADE_METHOD;
    static final Method JOBJECT_REVALIDATE_METHOD;
    static final Method JOBJECT_COPY_OUT_METHOD;
    static final Method JOBJECT_COPY_IN_METHOD;
    static final Method JOBJECT_COPY_TO_METHOD;
    static final Method GET_CURRENT_METHOD;
    static final Method READ_SIMPLE_FIELD_METHOD;
    static final Method WRITE_SIMPLE_FIELD_METHOD;
    static final Method READ_COUNTER_FIELD_METHOD;
    static final Method READ_SET_FIELD_METHOD;
    static final Method READ_LIST_FIELD_METHOD;
    static final Method READ_MAP_FIELD_METHOD;
    static final Method DELETE_METHOD;
    static final Method EXISTS_METHOD;
    static final Method RECREATE_METHOD;
    static final Method GET_SCHEMA_VERSION_METHOD;
    static final Method UPDATE_SCHEMA_VERSION_METHOD;
    static final Method REVALIDATE_METHOD;
    static final Method COPY_TO_METHOD;
    static final Method GET_SNAPSHOT_TRANSACTION_METHOD;
    static final Method GET_TRANSACTION_METHOD;
    static final Method GET_METHOD;
    static final Method REGISTER_JOBJECT_METHOD;
    static final Method CONVERTER_CONVERT_METHOD;
    static final Method CONVERTER_REVERSE_METHOD;
    static final Method ENUM_CONVERTER_CREATE_METHOD;
    static final Method TRANSACTION_READ_SIMPLE_FIELD_METHOD;
    static final Method TRANSACTION_WRITE_SIMPLE_FIELD_METHOD;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final JSimpleDB jdb;
    protected final JClass<T> jclass;
    protected final Class<T> modelClass;
    private Class<? extends T> subclass;
    private Constructor<? extends T> constructor;

    ClassGenerator(JClass<T> jclass) {
        this(jclass.jdb, jclass, jclass.type);
    }

    ClassGenerator(JSimpleDB jdb, Class<T> modelClass) {
        this(jdb, null, modelClass);
    }

    private ClassGenerator(JSimpleDB jdb, JClass<T> jclass, Class<T> modelClass) {
        this.jdb = jdb;
        this.jclass = jclass;
        this.modelClass = modelClass;
    }

    public Constructor<? extends T> getConstructor() {
        if (this.constructor == null) {
            if (this.subclass == null) {
                this.subclass = this.generateClass();
            }
            try {
                this.constructor = this.subclass.getConstructor(JTransaction.class, ObjId.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("internal error", e);
            }
            this.constructor.setAccessible(true);
        }
        return this.constructor;
    }

    public Class<? extends T> generateClass() {
        try {
            return this.jdb.loader.loadClass(this.getClassName().replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException("internal error", (Throwable)e);
        }
    }

    public String getClassName() {
        return this.getSuperclassName() + "$$JSimpleDB";
    }

    public String getSuperclassName() {
        return Type.getInternalName(this.modelClass);
    }

    protected byte[] generateBytecode() {
        this.log.debug("begin generating class " + this.getClassName());
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 4129, this.getClassName(), null, this.getSuperclassName(), new String[]{Type.getInternalName(JObject.class)});
        cw.visitSource(GEN_SOURCE, null);
        this.outputFields(cw);
        this.outputConstructors(cw);
        this.outputMethods(cw);
        cw.visitEnd();
        byte[] classfile = cw.toByteArray();
        this.log.debug("done generating class " + this.getClassName());
        this.debugDump(System.out, classfile);
        return classfile;
    }

    private void outputFields(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(20, TX_FIELD_NAME, Type.getDescriptor(JTransaction.class), null, null);
        fv.visitEnd();
        FieldVisitor idField = cw.visitField(20, ID_FIELD_NAME, Type.getDescriptor(ObjId.class), null, null);
        idField.visitEnd();
        if (this.jclass != null) {
            for (JField jfield : this.jclass.jfields.values()) {
                jfield.outputFields(this, cw);
            }
        }
    }

    private void outputConstructors(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(JTransaction.class), Type.getType(ObjId.class)), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        mv.visitMethodInsn(183, this.getSuperclassName(), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void outputMethods(ClassWriter cw) {
        if (this.jclass != null) {
            boolean needClassInitializer = false;
            for (JField jfield : this.jclass.jfields.values()) {
                if (!jfield.hasClassInitializerBytecode()) continue;
                needClassInitializer = true;
                break;
            }
            if (needClassInitializer) {
                MethodVisitor mv = cw.visitMethod(10, "<clinit>", "()V", null, null);
                mv.visitCode();
                for (JField jfield : this.jclass.jfields.values()) {
                    if (!jfield.hasClassInitializerBytecode()) continue;
                    jfield.outputClassInitializerBytecode(this, mv);
                }
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }
        MethodVisitor mv = this.startMethod(cw, JOBJECT_GET_TRANSACTION);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_GET_OBJ_ID_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_GET_SCHEMA_VERSION_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        this.emitInvoke(mv, GET_SCHEMA_VERSION_METHOD);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_DELETE_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        this.emitInvoke(mv, DELETE_METHOD);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_EXISTS_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        this.emitInvoke(mv, EXISTS_METHOD);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_IS_SNAPSHOT_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitTypeInsn(193, Type.getType(SnapshotJTransaction.class).getInternalName());
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_RECREATE_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        this.emitInvoke(mv, RECREATE_METHOD);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_REVALIDATE_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), ID_FIELD_NAME, Type.getDescriptor(ObjId.class));
        mv.visitVarInsn(25, 1);
        this.emitInvoke(mv, REVALIDATE_METHOD);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_UPGRADE_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        this.emitInvoke(mv, UPDATE_SCHEMA_VERSION_METHOD);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_COPY_TO_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        this.emitInvoke(mv, COPY_TO_METHOD);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_COPY_OUT_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, this.getClassName(), TX_FIELD_NAME, Type.getDescriptor(JTransaction.class));
        this.emitInvoke(mv, GET_SNAPSHOT_TRANSACTION_METHOD);
        mv.visitInsn(1);
        mv.visitTypeInsn(187, Type.getType(CopyState.class).getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getType(CopyState.class).getInternalName(), "<init>", "()V", false);
        mv.visitVarInsn(25, 1);
        this.emitInvoke(mv, JOBJECT_COPY_TO_METHOD);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = this.startMethod(cw, JOBJECT_COPY_IN_METHOD);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        this.emitInvoke(mv, GET_CURRENT_METHOD);
        mv.visitInsn(1);
        mv.visitTypeInsn(187, Type.getType(CopyState.class).getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getType(CopyState.class).getInternalName(), "<init>", "()V", false);
        mv.visitVarInsn(25, 1);
        this.emitInvoke(mv, JOBJECT_COPY_TO_METHOD);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (this.jclass == null) {
            return;
        }
        for (JField jfield : this.jclass.jfields.values()) {
            jfield.outputMethods(this, cw);
        }
    }

    protected void debugDump(PrintStream out, byte[] classfile) {
    }

    void wrap(MethodVisitor mv, Primitive<?> primitive) {
        Type wrapperType = Type.getType(primitive.getWrapperType());
        mv.visitMethodInsn(184, wrapperType.getInternalName(), "valueOf", Type.getMethodDescriptor(wrapperType, Type.getType(primitive.getType())), false);
    }

    void unwrap(MethodVisitor mv, Primitive<?> primitive) {
        Type wrapperType = Type.getType(primitive.getWrapperType());
        Method unwrapMethod = primitive.getUnwrapMethod();
        this.emitInvoke(mv, unwrapMethod);
    }

    void emitInvoke(MethodVisitor mv, Method method) {
        boolean isStatic;
        boolean isInterface = method.getDeclaringClass().isInterface();
        boolean bl = isStatic = (method.getModifiers() & 8) != 0;
        mv.visitMethodInsn(isInterface ? 185 : (isStatic ? 184 : 182), Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor(method), isInterface);
    }

    void emitInvoke(MethodVisitor mv, String className, Method method) {
        mv.visitMethodInsn(182, className, method.getName(), Type.getMethodDescriptor(method), false);
    }

    MethodVisitor startMethod(ClassWriter cw, Method method) {
        return cw.visitMethod(method.getModifiers() & 7, method.getName(), Type.getMethodDescriptor(method), null, this.getExceptionNames(method));
    }

    String[] getExceptionNames(Method method) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class<?> type : method.getExceptionTypes()) {
            list.add(Type.getType(type).getInternalName());
        }
        return list.toArray(new String[list.size()]);
    }

    static {
        try {
            JOBJECT_GET_OBJ_ID_METHOD = JObject.class.getMethod("getObjId", new Class[0]);
            JOBJECT_GET_SCHEMA_VERSION_METHOD = JObject.class.getMethod("getSchemaVersion", new Class[0]);
            JOBJECT_GET_TRANSACTION = JObject.class.getMethod("getTransaction", new Class[0]);
            JOBJECT_DELETE_METHOD = JObject.class.getMethod("delete", new Class[0]);
            JOBJECT_EXISTS_METHOD = JObject.class.getMethod("exists", new Class[0]);
            JOBJECT_IS_SNAPSHOT_METHOD = JObject.class.getMethod("isSnapshot", new Class[0]);
            JOBJECT_RECREATE_METHOD = JObject.class.getMethod("recreate", new Class[0]);
            JOBJECT_UPGRADE_METHOD = JObject.class.getMethod("upgrade", new Class[0]);
            JOBJECT_REVALIDATE_METHOD = JObject.class.getMethod("revalidate", Class[].class);
            JOBJECT_COPY_TO_METHOD = JObject.class.getMethod("copyTo", JTransaction.class, ObjId.class, CopyState.class, String[].class);
            JOBJECT_COPY_OUT_METHOD = JObject.class.getMethod("copyOut", String[].class);
            JOBJECT_COPY_IN_METHOD = JObject.class.getMethod("copyIn", String[].class);
            GET_CURRENT_METHOD = JTransaction.class.getMethod("getCurrent", new Class[0]);
            READ_SIMPLE_FIELD_METHOD = JTransaction.class.getMethod("readSimpleField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            WRITE_SIMPLE_FIELD_METHOD = JTransaction.class.getMethod("writeSimpleField", JObject.class, Integer.TYPE, Object.class, Boolean.TYPE);
            READ_COUNTER_FIELD_METHOD = JTransaction.class.getMethod("readCounterField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            READ_SET_FIELD_METHOD = JTransaction.class.getMethod("readSetField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            READ_LIST_FIELD_METHOD = JTransaction.class.getMethod("readListField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            READ_MAP_FIELD_METHOD = JTransaction.class.getMethod("readMapField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            DELETE_METHOD = JTransaction.class.getMethod("delete", JObject.class);
            EXISTS_METHOD = JTransaction.class.getMethod("exists", ObjId.class);
            RECREATE_METHOD = JTransaction.class.getMethod("recreate", JObject.class);
            GET_SCHEMA_VERSION_METHOD = JTransaction.class.getMethod("getSchemaVersion", ObjId.class);
            UPDATE_SCHEMA_VERSION_METHOD = JTransaction.class.getMethod("updateSchemaVersion", JObject.class);
            REVALIDATE_METHOD = JTransaction.class.getMethod("revalidate", ObjId.class, Class[].class);
            COPY_TO_METHOD = JTransaction.class.getMethod("copyTo", JTransaction.class, JObject.class, ObjId.class, CopyState.class, String[].class);
            GET_SNAPSHOT_TRANSACTION_METHOD = JTransaction.class.getMethod("getSnapshotTransaction", new Class[0]);
            GET_TRANSACTION_METHOD = JTransaction.class.getMethod("getTransaction", new Class[0]);
            GET_METHOD = JTransaction.class.getMethod("get", ObjId.class);
            REGISTER_JOBJECT_METHOD = JTransaction.class.getMethod("registerJObject", JObject.class);
            TRANSACTION_READ_SIMPLE_FIELD_METHOD = Transaction.class.getMethod("readSimpleField", ObjId.class, Integer.TYPE, Boolean.TYPE);
            TRANSACTION_WRITE_SIMPLE_FIELD_METHOD = Transaction.class.getMethod("writeSimpleField", ObjId.class, Integer.TYPE, Object.class, Boolean.TYPE);
            CONVERTER_CONVERT_METHOD = Converter.class.getMethod("convert", Object.class);
            CONVERTER_REVERSE_METHOD = Converter.class.getMethod("reverse", new Class[0]);
            ENUM_CONVERTER_CREATE_METHOD = EnumConverter.class.getMethod("createEnumConverter", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("internal error", e);
        }
    }

    static interface CodeEmitter {
        public void emit(MethodVisitor var1);
    }
}

