/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.ConvertedIndex;
import org.jsimpledb.IndexConverter;
import org.jsimpledb.NavigableSetConverter;
import org.jsimpledb.Tuple2Converter;
import org.jsimpledb.Tuple3Converter;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.tuple.Tuple3;
import org.jsimpledb.util.ConvertedNavigableMap;
import org.jsimpledb.util.ConvertedNavigableSet;

class ConvertedIndex2<V1, V2, T, WV1, WV2, WT>
implements Index2<V1, V2, T> {
    private final Index2<WV1, WV2, WT> index;
    private final Converter<V1, WV1> value1Converter;
    private final Converter<V2, WV2> value2Converter;
    private final Converter<T, WT> targetConverter;

    ConvertedIndex2(Index2<WV1, WV2, WT> index, Converter<V1, WV1> value1Converter, Converter<V2, WV2> value2Converter, Converter<T, WT> targetConverter) {
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"null index");
        Preconditions.checkArgument((value1Converter != null ? 1 : 0) != 0, (Object)"null value1Converter");
        Preconditions.checkArgument((value2Converter != null ? 1 : 0) != 0, (Object)"null value2Converter");
        Preconditions.checkArgument((targetConverter != null ? 1 : 0) != 0, (Object)"null targetConverter");
        this.index = index;
        this.value1Converter = value1Converter;
        this.value2Converter = value2Converter;
        this.targetConverter = targetConverter;
    }

    public NavigableSet<Tuple3<V1, V2, T>> asSet() {
        return new ConvertedNavigableSet(this.index.asSet(), new Tuple3Converter<V1, V2, T, WV1, WV2, WT>(this.value1Converter, this.value2Converter, this.targetConverter));
    }

    public NavigableMap<Tuple2<V1, V2>, NavigableSet<T>> asMap() {
        return new ConvertedNavigableMap(this.index.asMap(), new Tuple2Converter<V1, V2, WV1, WV2>(this.value1Converter, this.value2Converter), new NavigableSetConverter<T, WT>(this.targetConverter));
    }

    public NavigableMap<V1, Index<V2, T>> asMapOfIndex() {
        return new ConvertedNavigableMap(this.index.asMapOfIndex(), this.value1Converter, new IndexConverter<V2, T, WV2, WT>(this.value2Converter, this.targetConverter));
    }

    public Index<V1, V2> asIndex() {
        return new ConvertedIndex<V1, V2, WV1, WV2>(this.index.asIndex(), this.value1Converter, this.value2Converter);
    }
}

