/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import org.jsimpledb.ConvertedIndex2;
import org.jsimpledb.index.Index2;

class Index2Converter<V1, V2, T, WV1, WV2, WT>
extends Converter<Index2<V1, V2, T>, Index2<WV1, WV2, WT>> {
    private final Converter<V1, WV1> value1Converter;
    private final Converter<V2, WV2> value2Converter;
    private final Converter<T, WT> targetConverter;

    Index2Converter(Converter<V1, WV1> value1Converter, Converter<V2, WV2> value2Converter, Converter<T, WT> targetConverter) {
        Preconditions.checkArgument((value1Converter != null ? 1 : 0) != 0, (Object)"null value1Converter");
        Preconditions.checkArgument((value2Converter != null ? 1 : 0) != 0, (Object)"null value2Converter");
        Preconditions.checkArgument((targetConverter != null ? 1 : 0) != 0, (Object)"null targetConverter");
        this.value1Converter = value1Converter;
        this.value2Converter = value2Converter;
        this.targetConverter = targetConverter;
    }

    protected Index2<WV1, WV2, WT> doForward(Index2<V1, V2, T> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex2(index, this.value1Converter.reverse(), this.value2Converter.reverse(), this.targetConverter.reverse());
    }

    protected Index2<V1, V2, T> doBackward(Index2<WV1, WV2, WT> index) {
        if (index == null) {
            return null;
        }
        return new ConvertedIndex2<V1, V2, T, WV1, WV2, WT>(index, this.value1Converter, this.value2Converter, this.targetConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Index2Converter that = (Index2Converter)((Object)obj);
        return this.value1Converter.equals(that.value1Converter) && this.value2Converter.equals(that.value2Converter) && this.targetConverter.equals(that.targetConverter);
    }

    public int hashCode() {
        return this.value1Converter.hashCode() ^ this.value2Converter.hashCode() ^ this.targetConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[value1Converter=" + this.value1Converter + ",value2Converter=" + this.value2Converter + ",targetConverter=" + this.targetConverter + "]";
    }
}

