/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.Counter;
import org.jsimpledb.JCounterField;
import org.jsimpledb.JEnumField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldScanner;
import org.jsimpledb.JListField;
import org.jsimpledb.JListFieldScanner;
import org.jsimpledb.JMapFieldScanner;
import org.jsimpledb.JObject;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSetFieldScanner;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.MethodKey;
import org.jsimpledb.OnChangeScanner;
import org.jsimpledb.OnCreateScanner;
import org.jsimpledb.OnDeleteScanner;
import org.jsimpledb.OnValidateScanner;
import org.jsimpledb.OnVersionChangeScanner;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.JCompositeIndex;
import org.jsimpledb.annotation.JMapField;
import org.jsimpledb.annotation.JSetField;
import org.jsimpledb.annotation.JSimpleClass;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JClass<T>
extends JSchemaObject {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final Class<T> type;
    final ClassGenerator<T> classGenerator;
    final TreeMap<Integer, JField> jfields = new TreeMap();
    final TreeMap<String, JField> jfieldsByName = new TreeMap();
    final TreeMap<Integer, org.jsimpledb.JCompositeIndex> jcompositeIndexes = new TreeMap();
    final TreeMap<String, org.jsimpledb.JCompositeIndex> jcompositeIndexesByName = new TreeMap();
    final ArrayList<JSimpleField> uniqueConstraintFields = new ArrayList();
    Set<MethodAnnotationScanner.MethodInfo> onCreateMethods;
    Set<MethodAnnotationScanner.MethodInfo> onDeleteMethods;
    Set<MethodAnnotationScanner.MethodInfo> onChangeMethods;
    Set<MethodAnnotationScanner.MethodInfo> onValidateMethods;
    ArrayList<MethodAnnotationScanner.MethodInfo> onVersionChangeMethods;
    int[] subtypeStorageIds;
    boolean requiresDefaultValidation;
    AnnotatedElement elementRequiringJSR303Validation;

    JClass(JSimpleDB jdb, String name, int storageId, Class<T> type) {
        super(jdb, name, storageId, "object type `" + name + "' (" + type + ")");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        this.type = type;
        this.classGenerator = new ClassGenerator(this);
    }

    ClassGenerator<T> getClassGenerator() {
        return this.classGenerator;
    }

    public Class<T> getType() {
        return this.type;
    }

    public SortedMap<Integer, JField> getJFieldsByStorageId() {
        return Collections.unmodifiableSortedMap(this.jfields);
    }

    public SortedMap<String, JField> getJFieldsByName() {
        return Collections.unmodifiableSortedMap(this.jfieldsByName);
    }

    public <T extends JField> T getJField(int storageId, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        JField jfield = this.jfields.get(storageId);
        if (jfield == null) {
            throw new UnknownFieldException(storageId, "object type `" + this.name + "' has no field with storage ID " + storageId);
        }
        try {
            return (T)((JField)type.cast(jfield));
        }
        catch (ClassCastException e) {
            throw new UnknownFieldException(storageId, "object type `" + this.name + "' has no field with storage ID " + storageId + " of type " + type.getName() + " (found " + jfield + " instead)");
        }
    }

    void createFields(JSimpleDB jdb) {
        boolean autogenFields = this.type.getAnnotation(JSimpleClass.class).autogenFields();
        boolean autogenNonAbstract = this.type.getAnnotation(JSimpleClass.class).autogenNonAbstract();
        JFieldScanner simpleFieldScanner = new JFieldScanner(this, autogenFields, autogenNonAbstract);
        for (MethodAnnotationScanner.MethodInfo info : simpleFieldScanner.findAnnotatedMethods()) {
            Method setter;
            int storageId;
            org.jsimpledb.annotation.JField annotation = (org.jsimpledb.annotation.JField)info.getAnnotation();
            Method getter = info.getMethod();
            String description = simpleFieldScanner.getAnnotationDescription() + " annotation on method " + getter;
            String fieldName = this.getFieldName(annotation.name(), info, description);
            TypeToken fieldTypeToken = TypeToken.of(this.type).resolveType(getter.getGenericReturnType());
            if (this.log.isTraceEnabled()) {
                this.log.trace("found " + description);
            }
            if ((storageId = annotation.storageId()) == 0) {
                storageId = jdb.getStorageIdGenerator(annotation, getter).generateFieldStorageId(getter, fieldName);
            }
            if (fieldTypeToken.equals((Object)TypeToken.of(Counter.class))) {
                if (annotation.type().length() != 0) {
                    throw new IllegalArgumentException("invalid " + description + ": counter fields must not specify a type");
                }
                if (annotation.indexed()) {
                    throw new IllegalArgumentException("invalid " + description + ": counter fields cannot be indexed");
                }
                JCounterField jfield = new JCounterField(this.jdb, fieldName, storageId, "counter field `" + fieldName + "' of object type `" + this.name + "'", getter);
                jfield.parent = this;
                this.addField(jfield);
                continue;
            }
            try {
                setter = Util.findJFieldSetterMethod(this.type, getter);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid " + description + ": " + e.getMessage());
            }
            JSimpleField jfield = this.createSimpleField(description, fieldTypeToken, fieldName, storageId, annotation, getter, setter, "field `" + fieldName + "' of object type `" + this.name + "'");
            jfield.parent = this;
            this.addField(jfield);
            if (!jfield.unique) continue;
            this.uniqueConstraintFields.add(jfield);
        }
        JSetFieldScanner setFieldScanner = new JSetFieldScanner(this, autogenFields, autogenNonAbstract);
        for (MethodAnnotationScanner.MethodInfo info : setFieldScanner.findAnnotatedMethods()) {
            int elementStorageId;
            int storageId;
            JSetField annotation = (JSetField)info.getAnnotation();
            org.jsimpledb.annotation.JField elementAnnotation = annotation.element();
            Method getter = info.getMethod();
            String description = setFieldScanner.getAnnotationDescription() + " annotation on method " + getter;
            String fieldName = this.getFieldName(annotation.name(), info, description);
            if (this.log.isTraceEnabled()) {
                this.log.trace("found " + description);
            }
            if ((storageId = annotation.storageId()) == 0) {
                storageId = jdb.getStorageIdGenerator(annotation, getter).generateFieldStorageId(getter, fieldName);
            }
            if ((elementStorageId = elementAnnotation.storageId()) == 0) {
                elementStorageId = jdb.getStorageIdGenerator(elementAnnotation, getter).generateSetElementStorageId(getter, fieldName);
            }
            TypeToken elementType = TypeToken.of(this.type).resolveType(this.getParameterType(description, getter, 0));
            JSimpleField elementField = this.createSimpleField("element() property of " + description, elementType, "element", elementStorageId, elementAnnotation, null, null, "element field of set field `" + fieldName + "' in object type `" + this.name + "'");
            org.jsimpledb.JSetField jfield = new org.jsimpledb.JSetField(this.jdb, fieldName, storageId, elementField, "set field `" + fieldName + "' in object type `" + this.name + "'", getter);
            elementField.parent = jfield;
            this.addField(jfield);
        }
        JListFieldScanner listFieldScanner = new JListFieldScanner(this, autogenFields, autogenNonAbstract);
        for (MethodAnnotationScanner.MethodInfo info : listFieldScanner.findAnnotatedMethods()) {
            int elementStorageId;
            int storageId;
            org.jsimpledb.annotation.JListField annotation = (org.jsimpledb.annotation.JListField)info.getAnnotation();
            org.jsimpledb.annotation.JField elementAnnotation = annotation.element();
            Method getter = info.getMethod();
            String description = listFieldScanner.getAnnotationDescription() + " annotation on method " + getter;
            String fieldName = this.getFieldName(annotation.name(), info, description);
            if (this.log.isTraceEnabled()) {
                this.log.trace("found " + description);
            }
            if ((storageId = annotation.storageId()) == 0) {
                storageId = jdb.getStorageIdGenerator(annotation, getter).generateFieldStorageId(getter, fieldName);
            }
            if ((elementStorageId = elementAnnotation.storageId()) == 0) {
                elementStorageId = jdb.getStorageIdGenerator(elementAnnotation, getter).generateListElementStorageId(getter, fieldName);
            }
            TypeToken elementType = TypeToken.of(this.type).resolveType(this.getParameterType(description, getter, 0));
            JSimpleField elementField = this.createSimpleField("element() property of " + description, elementType, "element", elementStorageId, elementAnnotation, null, null, "element field of list field `" + fieldName + "' in object type `" + this.name + "'");
            JListField jfield = new JListField(this.jdb, fieldName, storageId, elementField, "list field `" + fieldName + "' in object type `" + this.name + "'", getter);
            elementField.parent = jfield;
            this.addField(jfield);
        }
        JMapFieldScanner mapFieldScanner = new JMapFieldScanner(this, autogenFields, autogenNonAbstract);
        for (MethodAnnotationScanner.MethodInfo info : mapFieldScanner.findAnnotatedMethods()) {
            int valueStorageId;
            int keyStorageId;
            int storageId;
            JMapField annotation = (JMapField)info.getAnnotation();
            org.jsimpledb.annotation.JField keyAnnotation = annotation.key();
            org.jsimpledb.annotation.JField valueAnnotation = annotation.value();
            Method getter = info.getMethod();
            String description = mapFieldScanner.getAnnotationDescription() + " annotation on method " + getter;
            String fieldName = this.getFieldName(annotation.name(), info, description);
            if (this.log.isTraceEnabled()) {
                this.log.trace("found " + description);
            }
            if ((storageId = annotation.storageId()) == 0) {
                storageId = jdb.getStorageIdGenerator(annotation, getter).generateFieldStorageId(getter, fieldName);
            }
            if ((keyStorageId = keyAnnotation.storageId()) == 0) {
                keyStorageId = jdb.getStorageIdGenerator(keyAnnotation, getter).generateMapKeyStorageId(getter, fieldName);
            }
            if ((valueStorageId = valueAnnotation.storageId()) == 0) {
                valueStorageId = jdb.getStorageIdGenerator(valueAnnotation, getter).generateMapValueStorageId(getter, fieldName);
            }
            TypeToken keyType = TypeToken.of(this.type).resolveType(this.getParameterType(description, getter, 0));
            TypeToken valueType = TypeToken.of(this.type).resolveType(this.getParameterType(description, getter, 1));
            JSimpleField keyField = this.createSimpleField("key() property of " + description, keyType, "key", keyStorageId, keyAnnotation, null, null, "key field of map field `" + fieldName + "' in object type `" + this.name + "'");
            JSimpleField valueField = this.createSimpleField("value() property of " + description, valueType, "value", valueStorageId, valueAnnotation, null, null, "value field of map field `" + fieldName + "' in object type `" + this.name + "'");
            org.jsimpledb.JMapField jfield = new org.jsimpledb.JMapField(this.jdb, fieldName, storageId, keyField, valueField, "map field `" + fieldName + "' in object type `" + this.name + "'", getter);
            keyField.parent = jfield;
            valueField.parent = jfield;
            this.addField(jfield);
        }
        Map<MethodKey, Method> abstractMethods = Util.findAbstractMethods(this.type);
        for (JField jfield : this.jfields.values()) {
            abstractMethods.remove(new MethodKey(jfield.getter));
            if (!(jfield instanceof JSimpleField)) continue;
            abstractMethods.remove(new MethodKey(((JSimpleField)jfield).setter));
        }
        for (Method method : JObject.class.getDeclaredMethods()) {
            abstractMethods.remove(new MethodKey(method));
        }
        if (!abstractMethods.isEmpty()) {
            throw new IllegalArgumentException("the @JSimpleClass-annotated type " + this.type.getName() + " is invalid because" + " " + abstractMethods.size() + " abstract method(s) remain unimplemented: " + abstractMethods.values().toString().replaceAll("^\\[(.*)\\]$", "$1"));
        }
        for (JField jfield : this.jfields.values()) {
            jfield.calculateRequiresDefaultValidation();
        }
    }

    void addCompositeIndex(JSimpleDB jdb, JCompositeIndex annotation) {
        String indexName = annotation.name();
        String[] fieldNames = annotation.fields();
        JSimpleField[] indexFields = new JSimpleField[fieldNames.length];
        int[] indexFieldStorageIds = new int[fieldNames.length];
        HashSet<String> seenFieldNames = new HashSet<String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            if (!seenFieldNames.add(fieldName)) {
                throw this.invalidIndex(annotation, "field `" + fieldName + "' appears more than once");
            }
            JField jfield = this.jfieldsByName.get(fieldName);
            if (!(jfield instanceof JSimpleField)) {
                throw this.invalidIndex(annotation, "field `" + fieldName + "' " + (jfield != null ? "is not a simple field" : "not found"));
            }
            indexFields[i] = (JSimpleField)jfield;
            indexFieldStorageIds[i] = jfield.storageId;
        }
        int storageId = annotation.storageId();
        if (storageId == 0) {
            storageId = jdb.getStorageIdGenerator(annotation, this.type).generateCompositeIndexStorageId(this.type, indexName, indexFieldStorageIds);
        }
        org.jsimpledb.JCompositeIndex index = new org.jsimpledb.JCompositeIndex(this.jdb, indexName, storageId, indexFields);
        if (this.jcompositeIndexes.put(index.storageId, index) != null) {
            throw this.invalidIndex(annotation, "duplicate use of storage ID " + index.storageId);
        }
        if (this.jcompositeIndexesByName.put(index.name, index) != null) {
            throw this.invalidIndex(annotation, "duplicate use of composite index name `" + index.name + "'");
        }
    }

    void scanAnnotations() {
        this.onCreateMethods = new OnCreateScanner(this).findAnnotatedMethods();
        this.onDeleteMethods = new OnDeleteScanner(this).findAnnotatedMethods();
        this.onChangeMethods = new OnChangeScanner(this).findAnnotatedMethods();
        this.onValidateMethods = new OnValidateScanner(this).findAnnotatedMethods();
        OnVersionChangeScanner onVersionChangeScanner = new OnVersionChangeScanner(this);
        this.onVersionChangeMethods = new ArrayList(onVersionChangeScanner.findAnnotatedMethods());
        Collections.sort(this.onVersionChangeMethods, onVersionChangeScanner);
    }

    void calculateValidationRequirement() {
        this.elementRequiringJSR303Validation = Util.hasValidation(this.type);
        this.requiresDefaultValidation = Util.requiresDefaultValidation(this.type);
        if (this.requiresDefaultValidation) {
            return;
        }
        for (JSimpleField jfield : Iterables.filter(this.jfields.values(), JSimpleField.class)) {
            if (!jfield.unique) continue;
            this.requiresDefaultValidation = true;
            return;
        }
    }

    SchemaObjectType toSchemaItem(JSimpleDB jdb) {
        SchemaObjectType schemaObjectType = new SchemaObjectType();
        this.initialize(jdb, (AbstractSchemaItem)schemaObjectType);
        for (JField field : this.jfields.values()) {
            SchemaField schemaField = field.toSchemaItem(jdb);
            schemaObjectType.getSchemaFields().put(schemaField.getStorageId(), schemaField);
        }
        for (org.jsimpledb.JCompositeIndex index : this.jcompositeIndexes.values()) {
            SchemaCompositeIndex schemaIndex = index.toSchemaItem(jdb);
            schemaObjectType.getSchemaCompositeIndexes().put(index.getStorageId(), schemaIndex);
        }
        return schemaObjectType;
    }

    private IllegalArgumentException invalidIndex(JCompositeIndex annotation, String message) {
        return new IllegalArgumentException("invalid @JCompositeIndex annotation for index `" + annotation.name() + "' on " + this.type + ": " + message);
    }

    private void addField(JField jfield) {
        JField other = this.jfields.get(jfield.storageId);
        if (other != null) {
            throw new IllegalArgumentException("illegal duplicate use of storage ID " + jfield.storageId + " for both " + other + " and " + jfield);
        }
        this.jfields.put(jfield.storageId, jfield);
        other = this.jfieldsByName.get(jfield.name);
        if (other != null) {
            throw new IllegalArgumentException("illegal duplicate use of field name `" + jfield.name + "' in " + this);
        }
        this.jfieldsByName.put(jfield.name, jfield);
        if (this.log.isTraceEnabled()) {
            this.log.trace("added " + jfield + " to object type `" + this.name + "'");
        }
    }

    private String getFieldName(String fieldName, MethodAnnotationScanner.MethodInfo info, String description) {
        if (fieldName.length() > 0) {
            return fieldName;
        }
        try {
            return info.getMethodPropertyName();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid " + description + ": can't infer field name: " + e, e);
        }
    }

    private Type getParameterType(String description, Method method, int index) {
        try {
            return Util.getTypeParameter(method.getGenericReturnType(), index);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid " + description + ": invalid method return type: " + e.getMessage(), e);
        }
    }

    private JSimpleField createSimpleField(String description, TypeToken<?> fieldTypeToken, String fieldName, int storageId, org.jsimpledb.annotation.JField annotation, Method getter, Method setter, String fieldDescription) {
        Class<Enum> enumType;
        boolean isSubField;
        String typeName = annotation.type().length() > 0 ? annotation.type() : null;
        description = description + " in " + this.type;
        boolean bl = isSubField = getter == null;
        if (isSubField && annotation.unique()) {
            throw new IllegalArgumentException("invalid " + description + ": unique() constraint not allowed on complex sub-field");
        }
        if (annotation.uniqueExclude().length > 0 && !annotation.unique()) {
            throw new IllegalArgumentException("invalid " + description + ": use of uniqueExclude() requires unique = true");
        }
        if (annotation.uniqueExcludeNull() && !annotation.unique()) {
            throw new IllegalArgumentException("invalid " + description + ": use of uniqueExcludeNull() requires unique = true");
        }
        boolean isReferenceType = false;
        for (JClass<?> jclass : this.jdb.jclasses.values()) {
            if (!fieldTypeToken.getRawType().isAssignableFrom(jclass.type)) continue;
            isReferenceType = true;
            break;
        }
        FieldType nonReferenceType = null;
        if (typeName != null) {
            TypeToken expectedType;
            nonReferenceType = this.jdb.db.getFieldTypeRegistry().getFieldType(typeName);
            if (nonReferenceType == null) {
                throw new IllegalArgumentException("invalid " + description + ": unknown simple field type `" + typeName + "'");
            }
            TypeToken typeToken = expectedType = isSubField ? nonReferenceType.getTypeToken().wrap() : nonReferenceType.getTypeToken();
            if (!expectedType.equals(fieldTypeToken)) {
                throw new IllegalArgumentException("invalid " + description + ": field type `" + typeName + "' supports values of type " + nonReferenceType.getTypeToken() + " but " + fieldTypeToken + " is required (according to the getter method's return type)");
            }
        } else {
            List fieldTypes = this.jdb.db.getFieldTypeRegistry().getFieldTypes(fieldTypeToken);
            switch (fieldTypes.size()) {
                case 0: {
                    nonReferenceType = null;
                    break;
                }
                case 1: {
                    nonReferenceType = (FieldType)fieldTypes.get(0);
                    break;
                }
                default: {
                    if (isReferenceType) break;
                    throw new IllegalArgumentException("invalid " + description + ": an explicit type() must be specified" + " because type " + fieldTypeToken + " is supported by multiple registered simple field types: " + fieldTypes);
                }
            }
        }
        Class<Enum> clazz = enumType = Enum.class.isAssignableFrom(fieldTypeToken.getRawType()) ? fieldTypeToken.getRawType().asSubclass(Enum.class) : null;
        if (!isReferenceType && nonReferenceType == null && enumType == null) {
            throw new IllegalArgumentException("invalid " + description + ": an explicit type() must be specified" + " because no known type supports values of type " + fieldTypeToken);
        }
        if (isReferenceType && nonReferenceType != null) {
            if (typeName != null) {
                isReferenceType = false;
            } else {
                throw new IllegalArgumentException("invalid " + description + ": an explicit type() must be specified" + " because type " + fieldTypeToken + " is ambiguous, being both a @" + JSimpleClass.class.getSimpleName() + " reference type and a simple Java type supported by type `" + nonReferenceType + "'");
            }
        }
        if (!isReferenceType && annotation.onDelete() != DeleteAction.EXCEPTION) {
            throw new IllegalArgumentException("invalid " + description + ": onDelete() only allowed on reference fields");
        }
        if (!isReferenceType && annotation.cascadeDelete()) {
            throw new IllegalArgumentException("invalid " + description + ": cascadeDelete() only allowed on reference fields");
        }
        if (!isReferenceType && annotation.unique() && !annotation.indexed()) {
            throw new IllegalArgumentException("invalid " + description + ": unique() constraint requires field to be indexed");
        }
        if (nonReferenceType != null && nonReferenceType.getTypeToken().isPrimitive() && annotation.uniqueExcludeNull()) {
            throw new IllegalArgumentException("invalid " + description + ": uniqueExcludeNull() is incompatible with fields" + " having primitive type");
        }
        try {
            return isReferenceType ? new JReferenceField(this.jdb, fieldName, storageId, fieldDescription, fieldTypeToken, annotation, getter, setter) : (enumType != null ? new JEnumField(this.jdb, fieldName, storageId, enumType, annotation, fieldDescription, getter, setter) : new JSimpleField(this.jdb, fieldName, storageId, fieldTypeToken, nonReferenceType, annotation.indexed(), annotation, fieldDescription, getter, setter));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid " + description + ": " + e.getMessage(), e);
        }
    }
}

