/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.Counter;
import org.jsimpledb.JCounterFieldInfo;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.CounterSchemaField;

public class JCounterField
extends JField {
    JCounterField(JSimpleDB jdb, String name, int storageId, String description, Method getter) {
        super(jdb, name, storageId, description, getter);
    }

    @Override
    public Counter getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readCounterField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJCounterField(this);
    }

    CounterSchemaField toSchemaItem(JSimpleDB jdb) {
        CounterSchemaField schemaField = new CounterSchemaField();
        this.initialize(jdb, (AbstractSchemaItem)schemaField);
        return schemaField;
    }

    @Override
    JCounterFieldInfo toJFieldInfo() {
        return new JCounterFieldInfo(this);
    }

    @Override
    void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueField(generator, cw);
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueGetterMethod(generator, cw, ClassGenerator.READ_COUNTER_FIELD_METHOD);
    }
}

