/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import org.jsimpledb.EnumConverter;
import org.jsimpledb.JEnumField;
import org.jsimpledb.JSimpleFieldInfo;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.EnumValue;

class JEnumFieldInfo
extends JSimpleFieldInfo {
    final Class<? extends Enum<?>> enumType;
    final EnumConverter<?> converter;

    JEnumFieldInfo(JEnumField jfield, int parentStorageId) {
        super(jfield, parentStorageId);
        this.enumType = jfield.getTypeToken().getRawType();
        this.converter = jfield.converter;
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    public Converter<EnumValue, ? extends Enum<?>> getConverter(JTransaction jtx) {
        return this.converter.reverse();
    }

    @Override
    public String toString() {
        return super.toString() + " and type " + this.enumType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        JEnumFieldInfo that = (JEnumFieldInfo)obj;
        return this.enumType == that.enumType;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.enumType.hashCode();
    }
}

