/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JListFieldInfo;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.ListSchemaField;

public class JListField
extends JCollectionField {
    JListField(JSimpleDB jdb, String name, int storageId, JSimpleField elementField, String description, Method getter) {
        super(jdb, name, storageId, elementField, description, getter);
    }

    @Override
    public List<?> getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readListField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJListField(this);
    }

    ListSchemaField toSchemaItem(JSimpleDB jdb) {
        ListSchemaField schemaField = new ListSchemaField();
        super.initialize(jdb, (CollectionSchemaField)schemaField);
        return schemaField;
    }

    @Override
    JListFieldInfo toJFieldInfo() {
        return new JListFieldInfo(this);
    }

    @Override
    Method getFieldReaderMethod() {
        return ClassGenerator.READ_LIST_FIELD_METHOD;
    }
}

