/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JMapFieldInfo;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.MapSchemaField;

public class JMapField
extends JComplexField {
    final JSimpleField keyField;
    final JSimpleField valueField;

    JMapField(JSimpleDB jdb, String name, int storageId, JSimpleField keyField, JSimpleField valueField, String description, Method getter) {
        super(jdb, name, storageId, description, getter);
        Preconditions.checkArgument((keyField != null ? 1 : 0) != 0, (Object)"null keyField");
        Preconditions.checkArgument((valueField != null ? 1 : 0) != 0, (Object)"null valueField");
        this.keyField = keyField;
        this.valueField = valueField;
    }

    public JSimpleField getKeyField() {
        return this.keyField;
    }

    public JSimpleField getValueField() {
        return this.valueField;
    }

    @Override
    public NavigableMap<?, ?> getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readMapField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJMapField(this);
    }

    @Override
    public List<JSimpleField> getSubFields() {
        return Arrays.asList(this.keyField, this.valueField);
    }

    @Override
    public JSimpleField getSubField(String name) {
        if ("key".equals(name)) {
            return this.keyField;
        }
        if ("value".equals(name)) {
            return this.valueField;
        }
        throw new IllegalArgumentException("unknown sub-field `" + name + "' (did you mean `" + "key" + "' or `" + "value" + "' instead?)");
    }

    @Override
    String getSubFieldName(JSimpleField subField) {
        if (subField == this.keyField) {
            return "key";
        }
        if (subField == this.valueField) {
            return "value";
        }
        throw new IllegalArgumentException("unknown sub-field");
    }

    MapSchemaField toSchemaItem(JSimpleDB jdb) {
        MapSchemaField schemaField = new MapSchemaField();
        super.initialize(jdb, (AbstractSchemaItem)schemaField);
        schemaField.setKeyField(this.keyField.toSchemaItem(jdb));
        schemaField.setValueField(this.valueField.toSchemaItem(jdb));
        return schemaField;
    }

    @Override
    JMapFieldInfo toJFieldInfo() {
        return new JMapFieldInfo(this);
    }

    @Override
    Method getFieldReaderMethod() {
        return ClassGenerator.READ_MAP_FIELD_METHOD;
    }
}

