/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.validation.ValidatorFactory;
import org.jsimpledb.DefaultStorageIdGenerator;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.StorageIdGenerator;
import org.jsimpledb.core.Database;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.simple.SimpleKVDatabase;

public class JSimpleDBFactory {
    private Database database;
    private int schemaVersion;
    private StorageIdGenerator storageIdGenerator = new DefaultStorageIdGenerator();
    private Iterable<? extends Class<?>> modelClasses;
    private ValidatorFactory validatorFactory;

    public JSimpleDBFactory setModelClasses(Iterable<? extends Class<?>> modelClasses) {
        this.modelClasses = modelClasses;
        return this;
    }

    public JSimpleDBFactory setModelClasses(Class<?> ... modelClasses) {
        return this.setModelClasses(Arrays.asList(modelClasses));
    }

    public JSimpleDBFactory setDatabase(Database database) {
        this.database = database;
        return this;
    }

    public JSimpleDBFactory setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public JSimpleDBFactory setStorageIdGenerator(StorageIdGenerator storageIdGenerator) {
        this.storageIdGenerator = storageIdGenerator;
        return this;
    }

    public JSimpleDBFactory setValidatorFactory(ValidatorFactory validatorFactory) {
        Preconditions.checkArgument((validatorFactory != null ? 1 : 0) != 0, (Object)"null validatorFactory");
        this.validatorFactory = validatorFactory;
        return this;
    }

    public JSimpleDB newJSimpleDB() {
        Database database1 = this.database;
        int schemaVersion1 = this.schemaVersion;
        if (database1 == null) {
            database1 = new Database((KVDatabase)new SimpleKVDatabase());
            if (schemaVersion1 == 0) {
                schemaVersion1 = 1;
            }
        }
        JSimpleDB jdb = new JSimpleDB(database1, schemaVersion1, this.storageIdGenerator, this.modelClasses);
        if (this.validatorFactory != null) {
            jdb.setValidatorFactory(this.validatorFactory);
        }
        return jdb;
    }
}

