/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import javax.validation.groups.Default;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.validation.ValidationContext;
import org.dellroad.stuff.validation.ValidationUtil;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.ConvertedIndex;
import org.jsimpledb.ConvertedIndex2;
import org.jsimpledb.ConvertedIndex3;
import org.jsimpledb.ConvertedIndex4;
import org.jsimpledb.CopyState;
import org.jsimpledb.Counter;
import org.jsimpledb.EnumConverter;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.IndexInfoKey;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexFieldInfo;
import org.jsimpledb.JCompositeIndexInfo;
import org.jsimpledb.JCounterFieldInfo;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldInfo;
import org.jsimpledb.JListFieldInfo;
import org.jsimpledb.JMapFieldInfo;
import org.jsimpledb.JObject;
import org.jsimpledb.JObjectCache;
import org.jsimpledb.JReferenceFieldInfo;
import org.jsimpledb.JSetFieldInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JSimpleFieldInfo;
import org.jsimpledb.ListConverter;
import org.jsimpledb.NavigableMapConverter;
import org.jsimpledb.NavigableSetConverter;
import org.jsimpledb.OnChangeScanner;
import org.jsimpledb.OnVersionChangeScanner;
import org.jsimpledb.ReferenceConverter;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.UniquenessConstraints;
import org.jsimpledb.Util;
import org.jsimpledb.ValidationException;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.annotation.OnChange;
import org.jsimpledb.annotation.OnCreate;
import org.jsimpledb.annotation.OnDelete;
import org.jsimpledb.annotation.OnValidate;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.core.CreateListener;
import org.jsimpledb.core.DeleteListener;
import org.jsimpledb.core.DeletedObjectException;
import org.jsimpledb.core.EnumField;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.FieldSwitch;
import org.jsimpledb.core.FieldSwitchAdapter;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.ReferenceField;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.StaleTransactionException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.VersionChangeListener;
import org.jsimpledb.core.util.ObjIdMap;
import org.jsimpledb.index.Index;
import org.jsimpledb.index.Index2;
import org.jsimpledb.index.Index3;
import org.jsimpledb.index.Index4;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.util.AbstractKVNavigableSet;
import org.jsimpledb.util.ConvertedNavigableMap;
import org.jsimpledb.util.ConvertedNavigableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTransaction {
    private static final ThreadLocal<JTransaction> CURRENT = new ThreadLocal();
    private static final Class<?>[] DEFAULT_CLASS_ARRAY = new Class[]{Default.class};
    private static final Class<?>[] DEFAULT_AND_UNIQUENESS_CLASS_ARRAY = new Class[]{Default.class, UniquenessConstraints.class};
    private static final int MAX_UNIQUE_CONFLICTORS = 5;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final JSimpleDB jdb;
    final Transaction tx;
    private final ValidationMode validationMode;
    private final DefaultValidationListener defaultValidationListener = new DefaultValidationListener();
    private final InternalCreateListener internalCreateListener = new InternalCreateListener();
    private final InternalDeleteListener internalDeleteListener = new InternalDeleteListener();
    private final InternalVersionChangeListener internalVersionChangeListener = new InternalVersionChangeListener();
    private final ObjIdMap<Class<?>[]> validationQueue = new ObjIdMap();
    private final JObjectCache jobjectCache = new JObjectCache(this);
    private SnapshotJTransaction snapshotTransaction;
    private boolean commitInvoked;

    JTransaction(JSimpleDB jdb, Transaction tx, ValidationMode validationMode) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((validationMode != null ? 1 : 0) != 0, (Object)"null validationMode");
        this.jdb = jdb;
        this.tx = tx;
        this.validationMode = validationMode;
        if (this.jdb.hasOnCreateMethods || validationMode == ValidationMode.AUTOMATIC && this.jdb.anyJClassRequiresDefaultValidation) {
            this.tx.addCreateListener((CreateListener)this.internalCreateListener);
        }
        if (this.jdb.hasOnDeleteMethods) {
            this.tx.addDeleteListener((DeleteListener)this.internalDeleteListener);
        }
        for (JClass<?> jclass : this.jdb.jclasses.values()) {
            for (MethodAnnotationScanner.MethodInfo info : jclass.onChangeMethods) {
                if (this instanceof SnapshotJTransaction && !((OnChange)info.getAnnotation()).snapshotTransactions()) continue;
                OnChangeScanner.ChangeMethodInfo changeInfo = (OnChangeScanner.ChangeMethodInfo)info;
                changeInfo.registerChangeListener(this);
            }
        }
        if (validationMode == ValidationMode.AUTOMATIC) {
            for (JFieldInfo jfieldInfo : this.jdb.jfieldInfos.values()) {
                if (!jfieldInfo.isRequiresDefaultValidation()) continue;
                jfieldInfo.registerChangeListener(this.tx, new int[0], null, this.defaultValidationListener);
            }
        }
        if (this.jdb.hasOnVersionChangeMethods || validationMode == ValidationMode.AUTOMATIC && this.jdb.anyJClassRequiresDefaultValidation) {
            this.tx.addVersionChangeListener((VersionChangeListener)this.internalVersionChangeListener);
        }
    }

    public static JTransaction getCurrent() {
        JTransaction jtx = CURRENT.get();
        if (jtx == null) {
            throw new IllegalStateException("there is no " + JTransaction.class.getSimpleName() + " associated with the current thread");
        }
        return jtx;
    }

    public static void setCurrent(JTransaction jtx) {
        CURRENT.set(jtx);
    }

    public JSimpleDB getJSimpleDB() {
        return this.jdb;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public <T> NavigableSet<T> getAll(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        NavigableSet ids = this.tx.getAll();
        KeyRanges keyRanges = this.jdb.keyRangesFor(type);
        if (!keyRanges.isFull()) {
            ids = ((AbstractKVNavigableSet)ids).filterKeys((KeyFilter)keyRanges);
        }
        return new ConvertedNavigableSet(ids, new ReferenceConverter<T>(this, type));
    }

    public <T> NavigableMap<Integer, NavigableSet<T>> queryVersion(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        CoreIndex index = this.tx.queryVersion();
        KeyRanges keyRanges = this.jdb.keyRangesFor(type);
        if (!keyRanges.isFull()) {
            index = index.filter(1, (KeyFilter)keyRanges);
        }
        return new ConvertedNavigableMap(index.asMap(), Converter.identity(), new NavigableSetConverter(new ReferenceConverter<T>(this, type)));
    }

    public byte[] getKey(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return this.tx.getKey(jobj.getObjId());
    }

    public byte[] getKey(JObject jobj, String fieldName) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Class type = this.jdb.getJClass((ObjId)jobj.getObjId()).type;
        ReferencePath refPath = this.jdb.parseReferencePath(type, fieldName, false);
        if (refPath.getReferenceFields().length > 0) {
            throw new IllegalArgumentException("invalid field name `" + fieldName + "'");
        }
        if (!refPath.targetType.isInstance(jobj)) {
            throw new IllegalArgumentException("jobj is not an instance of " + refPath.targetType);
        }
        return this.tx.getKey(jobj.getObjId(), refPath.targetFieldInfo.storageId);
    }

    public synchronized SnapshotJTransaction getSnapshotTransaction() {
        if (this.snapshotTransaction == null) {
            this.snapshotTransaction = this.createSnapshotTransaction(ValidationMode.MANUAL);
        }
        return this.snapshotTransaction;
    }

    public SnapshotJTransaction createSnapshotTransaction(ValidationMode validationMode) {
        return new SnapshotJTransaction(this.jdb, this.tx.createSnapshotTransaction(), validationMode);
    }

    public JObject copyTo(JTransaction dest, JObject srcObj, ObjId dstId, CopyState copyState, String ... refPaths) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((srcObj != null ? 1 : 0) != 0, (Object)"null srcObj");
        Preconditions.checkArgument((copyState != null ? 1 : 0) != 0, (Object)"null copyState");
        Preconditions.checkArgument((refPaths != null ? 1 : 0) != 0, (Object)"null refPaths");
        JTransaction.registerJObject(srcObj);
        ObjId srcId = srcObj.getObjId();
        if (dstId == null) {
            dstId = srcId;
        }
        if (this.tx == dest.tx && srcId.equals((Object)dstId)) {
            return dest.get(dstId);
        }
        Class startType = this.jdb.getJClass((ObjId)srcId).type;
        LinkedHashSet<ReferencePath> paths = new LinkedHashSet<ReferencePath>(refPaths.length);
        for (String refPath : refPaths) {
            Preconditions.checkArgument((refPath != null ? 1 : 0) != 0, (Object)"null refPath");
            ReferencePath path = this.jdb.parseReferencePath(startType, refPath, null);
            String lastFieldName = refPath.substring(refPath.lastIndexOf(46) + 1);
            JFieldInfo targetFieldInfo = this.jdb.jfieldInfos.get(path.getTargetField());
            if (targetFieldInfo instanceof JComplexFieldInfo) {
                JComplexFieldInfo superFieldInfo = (JComplexFieldInfo)targetFieldInfo;
                boolean foundReferenceSubFieldInfo = false;
                for (JSimpleFieldInfo subFieldInfo : superFieldInfo.getSubFieldInfos()) {
                    if (!(subFieldInfo instanceof JReferenceFieldInfo)) continue;
                    paths.add(this.jdb.parseReferencePath(startType, refPath + "." + superFieldInfo.getSubFieldInfoName(subFieldInfo), true));
                    foundReferenceSubFieldInfo = true;
                }
                if (foundReferenceSubFieldInfo) continue;
                throw new IllegalArgumentException("the last field `" + lastFieldName + "' of path `" + refPath + "' does not contain any reference sub-fields");
            }
            if (!(targetFieldInfo instanceof JReferenceFieldInfo)) {
                throw new IllegalArgumentException("the last field `" + lastFieldName + "' of path `" + path + "' is not a reference field");
            }
            paths.add(path);
        }
        if (paths.isEmpty()) {
            this.copyTo(copyState, dest, srcId, dstId, true, 0, new int[0]);
        }
        for (ReferencePath path : paths) {
            this.copyTo(copyState, dest, srcId, dstId, false, 0, Ints.concat((int[][])new int[][]{path.getReferenceFields(), {path.getTargetField()}}));
        }
        return dest.get(dstId);
    }

    public void copyTo(JTransaction dest, CopyState copyState, Iterable<? extends JObject> jobjs) {
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"null dest");
        Preconditions.checkArgument((copyState != null ? 1 : 0) != 0, (Object)"null copyState");
        Preconditions.checkArgument((jobjs != null ? 1 : 0) != 0, (Object)"null jobjs");
        if (this.tx == dest.tx) {
            return;
        }
        for (JObject jObject : jobjs) {
            if (jObject == null) continue;
            JTransaction.registerJObject(jObject);
            ObjId id = jObject.getObjId();
            this.copyTo(copyState, dest, id, id, true, 0, new int[0]);
        }
    }

    void copyTo(CopyState copyState, JTransaction dest, ObjId srcId, ObjId dstId, boolean required, int fieldIndex, int[] fields) {
        int storageId;
        JReferenceFieldInfo referenceFieldInfo;
        int parentStorageId;
        int[] pathSuffix;
        block9: {
            if (copyState.markCopied(dstId)) {
                try {
                    this.tx.copy(srcId, dstId, dest.tx, true);
                }
                catch (DeletedObjectException e) {
                    if (!required) break block9;
                    throw e;
                }
            }
        }
        if (fieldIndex == fields.length) {
            return;
        }
        int[] nArray = pathSuffix = fieldIndex == 0 ? fields : Arrays.copyOfRange(fields, fieldIndex, fields.length);
        if (!copyState.markTraversed(srcId, pathSuffix)) {
            return;
        }
        if ((parentStorageId = (referenceFieldInfo = this.jdb.getJFieldInfo(storageId = fields[fieldIndex++], JReferenceFieldInfo.class)).getParentStorageId()) != 0) {
            JComplexFieldInfo parentInfo = this.jdb.getJFieldInfo(parentStorageId, JComplexFieldInfo.class);
            parentInfo.copyRecurse(copyState, this, dest, srcId, storageId, fieldIndex, fields);
        } else {
            assert (referenceFieldInfo instanceof JReferenceFieldInfo);
            ObjId referrent = (ObjId)this.tx.readSimpleField(srcId, storageId, false);
            if (referrent != null) {
                this.copyTo(copyState, dest, referrent, referrent, false, fieldIndex, fields);
            }
        }
    }

    public JObject get(ObjId id) {
        return this.jobjectCache.get(id);
    }

    public <T> T get(ObjId id, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        return type.cast(this.get(id));
    }

    public <T extends JObject> T get(T jobj) {
        Class<?> modelClass = JSimpleDB.getModelClass(jobj);
        if (modelClass == null) {
            throw new IllegalArgumentException("can't determine model class for type " + jobj.getClass().getName());
        }
        return (T)((JObject)modelClass.cast(this.get(jobj.getObjId())));
    }

    @Deprecated
    public JObject getJObject(ObjId id) {
        return this.get(id);
    }

    @Deprecated
    public <T> T getJObject(ObjId id, Class<T> type) {
        return this.get(id, type);
    }

    @Deprecated
    public <T extends JObject> T getJObject(T jobj) {
        return this.get(jobj);
    }

    public <T> T create(Class<T> type) {
        return this.create(this.jdb.getJClass(type));
    }

    public <T> T create(JClass<T> jclass) {
        ObjId id = this.tx.create(jclass.storageId);
        return jclass.getType().cast(this.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(JObject jobj) {
        JTransaction.registerJObject(jobj);
        ObjId id = jobj.getObjId();
        boolean deleted = this.tx.delete(id);
        if (deleted) {
            JTransaction jTransaction = this;
            synchronized (jTransaction) {
                this.validationQueue.remove((Object)id);
            }
        }
        return deleted;
    }

    public boolean exists(ObjId id) {
        return this.tx.exists(id);
    }

    public boolean recreate(JObject jobj) {
        JTransaction.registerJObject(jobj);
        return this.tx.create(jobj.getObjId());
    }

    public void revalidate(ObjId id, Class<?> ... groups) {
        if (!this.tx.exists(id)) {
            throw new DeletedObjectException(this.getTransaction(), id);
        }
        this.revalidate(Collections.singleton(id), groups);
    }

    public synchronized void resetValidationQueue() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        this.validationQueue.clear();
    }

    private synchronized void revalidate(Collection<? extends ObjId> ids, Class<?> ... groups) {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        Preconditions.checkArgument((groups != null ? 1 : 0) != 0, (Object)"null groups");
        for (Class<?> group : groups) {
            Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"null group");
        }
        if (this.validationMode == ValidationMode.DISABLED) {
            return;
        }
        if (groups.length == 0 || Arrays.equals(groups, DEFAULT_CLASS_ARRAY)) {
            groups = DEFAULT_CLASS_ARRAY;
        }
        for (ObjId objId : ids) {
            Class[] existingGroups = (Class[])this.validationQueue.get((Object)objId);
            if (existingGroups == null) {
                this.validationQueue.put(objId, groups);
                continue;
            }
            if (existingGroups == groups) continue;
            HashSet<Class> newGroups = new HashSet<Class>(Arrays.asList(existingGroups));
            newGroups.addAll(Arrays.asList(groups));
            this.validationQueue.put(objId, (Object)newGroups.toArray(new Class[newGroups.size()]));
        }
    }

    public int getSchemaVersion(ObjId id) {
        return this.tx.getSchemaVersion(id);
    }

    public boolean updateSchemaVersion(JObject jobj) {
        JTransaction.registerJObject(jobj);
        return this.tx.updateSchemaVersion(jobj.getObjId());
    }

    public static void registerJObject(JObject jobj) {
        jobj.getTransaction().jobjectCache.register(jobj);
    }

    public Object readSimpleField(ObjId id, int storageId, boolean updateVersion) {
        return this.convert(this.jdb.getJFieldInfo(storageId, JSimpleFieldInfo.class).getConverter(this), this.tx.readSimpleField(id, storageId, updateVersion));
    }

    public void writeSimpleField(JObject jobj, int storageId, Object value, boolean updateVersion) {
        JTransaction.registerJObject(jobj);
        Converter<?, ?> converter = this.jdb.getJFieldInfo(storageId, JSimpleFieldInfo.class).getConverter(this);
        if (converter != null) {
            value = this.convert(converter.reverse(), value);
        }
        this.tx.writeSimpleField(jobj.getObjId(), storageId, value, updateVersion);
    }

    public Counter readCounterField(ObjId id, int storageId, boolean updateVersion) {
        this.jdb.getJFieldInfo(storageId, JCounterFieldInfo.class);
        if (updateVersion) {
            this.tx.updateSchemaVersion(id);
        }
        return new Counter(this.tx, id, storageId, updateVersion);
    }

    public NavigableSet<?> readSetField(ObjId id, int storageId, boolean updateVersion) {
        return (NavigableSet)this.convert(this.jdb.getJFieldInfo(storageId, JSetFieldInfo.class).getConverter(this), this.tx.readSetField(id, storageId, updateVersion));
    }

    public List<?> readListField(ObjId id, int storageId, boolean updateVersion) {
        return (List)this.convert(this.jdb.getJFieldInfo(storageId, JListFieldInfo.class).getConverter(this), this.tx.readListField(id, storageId, updateVersion));
    }

    public NavigableMap<?, ?> readMapField(ObjId id, int storageId, boolean updateVersion) {
        return (NavigableMap)this.convert(this.jdb.getJFieldInfo(storageId, JMapFieldInfo.class).getConverter(this), this.tx.readMapField(id, storageId, updateVersion));
    }

    public <T> NavigableSet<T> invertReferencePath(Class<T> startType, String path, Iterable<? extends JObject> targetObjects) {
        Preconditions.checkArgument((targetObjects != null ? 1 : 0) != 0, (Object)"null targetObjects");
        ReferencePath refPath = this.jdb.parseReferencePath(startType, path, true);
        int targetField = refPath.getTargetField();
        try {
            this.jdb.getJFieldInfo(targetField, JReferenceFieldInfo.class);
        }
        catch (UnknownFieldException e) {
            String fieldName = path.substring(path.lastIndexOf(46) + 1);
            throw new IllegalArgumentException("last field `" + fieldName + "' of path `" + path + "' is not a reference field", e);
        }
        int[] refs = Ints.concat((int[][])new int[][]{refPath.getReferenceFields(), {targetField}});
        NavigableSet ids = this.tx.invertReferencePath(refs, Iterables.transform(targetObjects, new ReferenceConverter<JObject>(this, JObject.class)));
        return new ConvertedNavigableSet(ids, new ReferenceConverter<T>(this, startType));
    }

    public <V, T> Index<V, T> queryIndex(Class<T> targetType, String fieldName, Class<V> valueType) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(fieldName, false, targetType, valueType));
        CoreIndex index = info.applyFilters(this.tx.queryIndex(info.fieldInfo.storageId));
        Converter<?, ?> valueConverter = this.getReverseConverter(info.fieldInfo);
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex(index, valueConverter, targetConverter);
    }

    public <V, T> Index2<V, T, Integer> queryListElementIndex(Class<T> targetType, String fieldName, Class<V> valueType) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(fieldName, false, targetType, valueType));
        if (!(info.superFieldInfo instanceof JListFieldInfo)) {
            throw new IllegalArgumentException("`" + fieldName + "' is not a list element sub-field");
        }
        CoreIndex2 index = info.applyFilters(this.tx.queryListElementIndex(info.superFieldInfo.storageId));
        Converter<?, ?> valueConverter = this.getReverseConverter(info.fieldInfo);
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, valueConverter, targetConverter, Converter.identity());
    }

    public <V, T, K> Index2<V, T, K> queryMapValueIndex(Class<T> targetType, String fieldName, Class<V> valueType, Class<K> keyType) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(fieldName, false, targetType, valueType, keyType));
        if (!(info.superFieldInfo instanceof JMapFieldInfo)) {
            throw new IllegalArgumentException("`" + fieldName + "' is not a map value sub-field");
        }
        JMapFieldInfo mapFieldInfo = (JMapFieldInfo)info.superFieldInfo;
        if (!info.fieldInfo.equals(mapFieldInfo.getValueFieldInfo())) {
            throw new IllegalArgumentException("`" + fieldName + "' is not a map value sub-field");
        }
        CoreIndex2 index = info.applyFilters(this.tx.queryMapValueIndex(mapFieldInfo.storageId));
        Converter<?, ?> valueConverter = this.getReverseConverter(info.fieldInfo);
        Converter<?, ?> keyConverter = this.getReverseConverter(mapFieldInfo.getKeyFieldInfo());
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, valueConverter, targetConverter, keyConverter);
    }

    public <V1, V2, T> Index2<V1, V2, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(indexName, true, targetType, value1Type, value2Type));
        CoreIndex2 index = info.applyFilters(this.tx.queryCompositeIndex2(info.indexInfo.storageId));
        Converter<?, ?> value1Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(0));
        Converter<?, ?> value2Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(1));
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex2(index, value1Converter, value2Converter, targetConverter);
    }

    public <V1, V2, V3, T> Index3<V1, V2, V3, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type, Class<V3> value3Type) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(indexName, true, targetType, value1Type, value2Type, value3Type));
        CoreIndex3 index = info.applyFilters(this.tx.queryCompositeIndex3(info.indexInfo.storageId));
        Converter<?, ?> value1Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(0));
        Converter<?, ?> value2Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(1));
        Converter<?, ?> value3Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(2));
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex3(index, value1Converter, value2Converter, value3Converter, targetConverter);
    }

    public <V1, V2, V3, V4, T> Index4<V1, V2, V3, V4, T> queryCompositeIndex(Class<T> targetType, String indexName, Class<V1> value1Type, Class<V2> value2Type, Class<V3> value3Type, Class<V4> value4Type) {
        IndexInfo info = this.jdb.getIndexInfo(new IndexInfoKey(indexName, true, targetType, value1Type, value2Type, value3Type, value4Type));
        CoreIndex4 index = info.applyFilters(this.tx.queryCompositeIndex4(info.indexInfo.storageId));
        Converter<?, ?> value1Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(0));
        Converter<?, ?> value2Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(1));
        Converter<?, ?> value3Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(2));
        Converter<?, ?> value4Converter = this.getReverseConverter(info.indexInfo.jfieldInfos.get(3));
        ReferenceConverter<T> targetConverter = new ReferenceConverter<T>(this, targetType);
        return new ConvertedIndex4(index, value1Converter, value2Converter, value3Converter, value4Converter, targetConverter);
    }

    public Object queryIndex(int storageId) {
        JComplexFieldInfo parentInfo;
        JCompositeIndexInfo indexInfo = this.jdb.jcompositeIndexInfos.get(storageId);
        if (indexInfo != null) {
            ReferenceConverter<JObject> targetConverter = new ReferenceConverter<JObject>(this, JObject.class);
            switch (indexInfo.jfieldInfos.size()) {
                case 2: {
                    Converter<?, ?> value1Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(0));
                    Converter<?, ?> value2Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(1));
                    return new ConvertedIndex2(this.tx.queryCompositeIndex2(indexInfo.storageId), value1Converter, value2Converter, targetConverter);
                }
                case 3: {
                    Converter<?, ?> value1Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(0));
                    Converter<?, ?> value2Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(1));
                    Converter<?, ?> value3Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(2));
                    return new ConvertedIndex3(this.tx.queryCompositeIndex3(indexInfo.storageId), value1Converter, value2Converter, value3Converter, targetConverter);
                }
                case 4: {
                    Converter<?, ?> value1Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(0));
                    Converter<?, ?> value2Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(1));
                    Converter<?, ?> value3Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(2));
                    Converter<?, ?> value4Converter = this.getReverseConverter(indexInfo.jfieldInfos.get(3));
                    return new ConvertedIndex4(this.tx.queryCompositeIndex4(indexInfo.storageId), value1Converter, value2Converter, value3Converter, value4Converter, targetConverter);
                }
            }
            throw new RuntimeException("internal error");
        }
        JFieldInfo someFieldInfo = this.jdb.jfieldInfos.get(storageId);
        if (someFieldInfo == null) {
            throw new IllegalArgumentException("no composite index or simple indexed field exists with storage ID " + storageId);
        }
        if (!(someFieldInfo instanceof JSimpleFieldInfo) || !((JSimpleFieldInfo)someFieldInfo).isIndexed()) {
            throw new IllegalArgumentException("storage ID " + storageId + " does not correspond to an indexed simple field (found " + someFieldInfo + " instead)");
        }
        JSimpleFieldInfo fieldInfo = (JSimpleFieldInfo)someFieldInfo;
        Converter<?, ?> valueConverter = this.getReverseConverter(fieldInfo);
        ReferenceConverter<JObject> referenceConverter = new ReferenceConverter<JObject>(this, JObject.class);
        int parentStorageId = fieldInfo.getParentStorageId();
        JComplexFieldInfo jComplexFieldInfo = parentInfo = parentStorageId != 0 ? this.jdb.getJFieldInfo(parentStorageId, JComplexFieldInfo.class) : null;
        if (parentInfo instanceof JListFieldInfo) {
            return new ConvertedIndex2(this.tx.queryListElementIndex(fieldInfo.storageId), valueConverter, referenceConverter, Converter.identity());
        }
        if (parentInfo instanceof JMapFieldInfo && ((JMapFieldInfo)parentInfo).getSubFieldInfoName(fieldInfo).equals("value")) {
            JMapFieldInfo mapFieldInfo = (JMapFieldInfo)parentInfo;
            JSimpleFieldInfo keyFieldInfo = mapFieldInfo.getKeyFieldInfo();
            Converter<?, ?> keyConverter = this.getReverseConverter(keyFieldInfo);
            return new ConvertedIndex2(this.tx.queryMapValueIndex(fieldInfo.storageId), valueConverter, referenceConverter, keyConverter);
        }
        return new ConvertedIndex(this.tx.queryIndex(fieldInfo.storageId), valueConverter, referenceConverter);
    }

    private Converter<?, ?> getReverseConverter(JSimpleFieldInfo fieldInfo) {
        Converter<?, ?> converter = fieldInfo.getConverter(this);
        return converter != null ? converter.reverse() : Converter.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        JTransaction jTransaction = this;
        synchronized (jTransaction) {
            if (this.commitInvoked) {
                throw new IllegalStateException("commit() invoked re-entrantly");
            }
            this.commitInvoked = true;
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            this.tx.rollback();
            throw e;
        }
        this.tx.commit();
    }

    public void rollback() {
        this.tx.rollback();
    }

    public boolean isValid() {
        return this.tx.isValid();
    }

    public void validate() {
        if (!this.tx.isValid()) {
            throw new StaleTransactionException(this.tx);
        }
        if (this.validationMode == ValidationMode.DISABLED) {
            return;
        }
        this.performAction(new Runnable(){

            @Override
            public void run() {
                JTransaction.this.doValidate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Runnable action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        JTransaction previous = CURRENT.get();
        CURRENT.set(this);
        try {
            action.run();
        }
        finally {
            CURRENT.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doValidate() {
        validatorFactory = this.jdb.getValidatorFactory();
        validator = validatorFactory != null ? validatorFactory.getValidator() : null;
        block5: while (true) {
            var3_3 = this;
            synchronized (var3_3) {
                i = this.validationQueue.entrySet().iterator();
                try {
                    entry = (Map.Entry)i.next();
                }
                catch (NoSuchElementException e) {
                    return;
                }
                id = (ObjId)entry.getKey();
                validationGroups = (Class[])entry.getValue();
                if (!JTransaction.$assertionsDisabled && id == null) {
                    throw new AssertionError();
                }
                if (!JTransaction.$assertionsDisabled && validationGroups == null) {
                    throw new AssertionError();
                }
                i.remove();
            }
            if (!this.tx.exists(id)) continue;
            jobj = this.get(id);
            jclass = this.jdb.jclasses.get(id.getStorageId());
            if (jclass == null) {
                return;
            }
            if (validator != null && !(violations = new ValidationContext((Object)jobj, validationGroups).validate(validator)).isEmpty()) {
                throw new ValidationException(jobj, violations, "validation error for object " + id + " of type `" + this.jdb.jclasses.get((Object)Integer.valueOf((int)id.getStorageId())).name + "':\n" + ValidationUtil.describe((Set)violations));
            }
            for (MethodAnnotationScanner.MethodInfo info : jclass.onValidateMethods) {
                methodGroups = ((OnValidate)info.getAnnotation()).groups();
                if (methodGroups.length == 0) {
                    methodGroups = JTransaction.DEFAULT_CLASS_ARRAY;
                }
                if (!Util.isAnyGroupBeingValidated(methodGroups, validationGroups)) continue;
                Util.invoke(info.getMethod(), jobj, new Object[0]);
            }
            if (jclass.uniqueConstraintFields.isEmpty() || !Util.isAnyGroupBeingValidated(JTransaction.DEFAULT_AND_UNIQUENESS_CLASS_ARRAY, validationGroups)) continue;
            i$ = jclass.uniqueConstraintFields.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block5;
                jfield = (JSimpleField)i$.next();
                if (!JTransaction.$assertionsDisabled && !jfield.indexed) {
                    throw new AssertionError();
                }
                if (!JTransaction.$assertionsDisabled && !jfield.unique) {
                    throw new AssertionError();
                }
                value = this.tx.readSimpleField(id, jfield.storageId, false);
                if (jfield.uniqueExcludes != null && Collections.binarySearch(jfield.uniqueExcludes, value, jfield.fieldType) >= 0) continue;
                conflictors = new ArrayList<ObjId>(5);
                for (ObjId conflictor : (NavigableSet)this.tx.queryIndex(jfield.storageId).asMap().get(value)) {
                    if (conflictor.equals((Object)id)) continue;
                    conflictors.add(conflictor);
                    if (conflictors.size() < 5) continue;
                    break;
                }
                if (!conflictors.isEmpty()) break block5;
            }
            break;
        }
        throw new ValidationException(jobj, "uniqueness constraint on " + jfield + " failed: field value " + value + " is also shared by object(s) " + conflictors);
    }

    private <X, Y> Y convert(Converter<X, Y> converter, Object value) {
        return (Y)(converter != null ? converter.convert(value) : value);
    }

    Object convertCoreValue(Field<?> field, Object value) {
        return value != null ? this.convert((Converter)field.visit((FieldSwitch)new CoreValueConverterBuilder()), value) : null;
    }

    private class DefaultValidationListener
    implements AllChangesListener {
        private DefaultValidationListener() {
        }

        public <T> void onSimpleFieldChange(Transaction tx, ObjId id, SimpleField<T> field, int[] path, NavigableSet<ObjId> referrers, T oldValue, T newValue) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <E> void onSetFieldAdd(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <E> void onSetFieldRemove(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public void onSetFieldClear(Transaction tx, ObjId id, SetField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldAdd(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldRemove(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <E> void onListFieldReplace(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E oldValue, E newValue) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public void onListFieldClear(Transaction tx, ObjId id, ListField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldAdd(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldRemove(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public <K, V> void onMapFieldReplace(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V oldValue, V newValue) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        public void onMapFieldClear(Transaction tx, ObjId id, MapField<?, ?> field, int[] path, NavigableSet<ObjId> referrers) {
            this.revalidateIfNeeded(id, (Field<?>)field, referrers);
        }

        private void revalidateIfNeeded(ObjId id, Field<?> field, NavigableSet<ObjId> referrers) {
            JClass<?> jclass;
            try {
                jclass = JTransaction.this.jdb.getJClass(id);
            }
            catch (TypeNotInSchemaVersionException e) {
                return;
            }
            JField jfield = jclass.getJField(field.getStorageId(), JField.class);
            if (jfield.requiresDefaultValidation) {
                JTransaction.this.revalidate(referrers, new Class[0]);
            }
        }
    }

    class CoreValueConverterBuilder
    extends FieldSwitchAdapter<Converter<?, ?>> {
        CoreValueConverterBuilder() {
        }

        public Converter<?, ?> caseEnumField(EnumField field) {
            Class enumType = field.getFieldType().getEnumType();
            return enumType != null ? EnumConverter.createEnumConverter(enumType).reverse() : null;
        }

        public Converter<?, ?> caseReferenceField(ReferenceField field) {
            return new ReferenceConverter<JObject>(JTransaction.this, JObject.class).reverse();
        }

        public <E> Converter<?, ?> caseSetField(SetField<E> field) {
            Converter elementConverter = (Converter)field.getElementField().visit((FieldSwitch)this);
            return elementConverter != null ? new NavigableSetConverter(elementConverter) : null;
        }

        public <E> Converter<?, ?> caseListField(ListField<E> field) {
            Converter elementConverter = (Converter)field.getElementField().visit((FieldSwitch)this);
            return elementConverter != null ? new ListConverter(elementConverter) : null;
        }

        public <K, V> Converter<?, ?> caseMapField(MapField<K, V> field) {
            Converter keyConverter = (Converter)field.getKeyField().visit((FieldSwitch)this);
            Converter valueConverter = (Converter)field.getValueField().visit((FieldSwitch)this);
            if (keyConverter != null || valueConverter != null) {
                if (keyConverter == null) {
                    keyConverter = Converter.identity();
                }
                if (valueConverter == null) {
                    valueConverter = Converter.identity();
                }
                return new NavigableMapConverter(keyConverter, valueConverter);
            }
            return null;
        }

        public <T> Converter caseField(Field<T> field) {
            return null;
        }
    }

    private class InternalVersionChangeListener
    implements VersionChangeListener {
        private InternalVersionChangeListener() {
        }

        public void onVersionChange(Transaction tx, ObjId id, int oldVersion, int newVersion, Map<Integer, Object> oldFieldValues) {
            JClass<?> jclass;
            try {
                jclass = JTransaction.this.jdb.getJClass(id);
            }
            catch (TypeNotInSchemaVersionException e) {
                return;
            }
            this.doOnVersionChange(jclass, id, oldVersion, newVersion, oldFieldValues);
        }

        private <T> void doOnVersionChange(JClass<T> jclass, ObjId id, int oldVersion, int newVersion, Map<Integer, Object> oldFieldValues) {
            if (JTransaction.this.validationMode == ValidationMode.AUTOMATIC && jclass.requiresDefaultValidation) {
                JTransaction.this.revalidate(Collections.singleton(id), new Class[0]);
            }
            if (jclass.onVersionChangeMethods.isEmpty()) {
                return;
            }
            Schema oldSchema = JTransaction.this.tx.getSchemas().getVersion(oldVersion);
            final ObjType objType = oldSchema.getObjType(id.getStorageId());
            JObject jobj = null;
            final Map oldValuesByStorageId = Maps.transformEntries(oldFieldValues, (Maps.EntryTransformer)new Maps.EntryTransformer<Integer, Object, Object>(){

                public Object transformEntry(Integer storageId, Object oldValue) {
                    return JTransaction.this.convertCoreValue(objType.getField(storageId.intValue()), oldValue);
                }
            });
            SortedMap oldValuesByName = Maps.transformValues((SortedMap)objType.getFieldsByName(), (Function)new Function<Field<?>, Object>(){

                public Object apply(Field<?> field) {
                    return oldValuesByStorageId.get(field.getStorageId());
                }
            });
            for (MethodAnnotationScanner.MethodInfo info0 : jclass.onVersionChangeMethods) {
                OnVersionChangeScanner.VersionChangeMethodInfo info = (OnVersionChangeScanner.VersionChangeMethodInfo)info0;
                if (jobj == null) {
                    jobj = JTransaction.this.get(id);
                }
                info.invoke(jobj, oldVersion, newVersion, oldValuesByStorageId, oldValuesByName);
            }
        }
    }

    private class InternalDeleteListener
    implements DeleteListener {
        private InternalDeleteListener() {
        }

        public void onDelete(Transaction tx, ObjId id) {
            JClass<?> jclass;
            try {
                jclass = JTransaction.this.jdb.getJClass(id);
            }
            catch (TypeNotInSchemaVersionException e) {
                return;
            }
            this.doOnDelete(jclass, id);
        }

        private <T> void doOnDelete(JClass<T> jclass, ObjId id) {
            JObject jobj = null;
            for (MethodAnnotationScanner.MethodInfo info : jclass.onDeleteMethods) {
                if (JTransaction.this instanceof SnapshotJTransaction && !((OnDelete)info.getAnnotation()).snapshotTransactions()) continue;
                if (jobj == null) {
                    jobj = JTransaction.this.get(id);
                }
                Util.invoke(info.getMethod(), jobj, new Object[0]);
            }
        }
    }

    private class InternalCreateListener
    implements CreateListener {
        private InternalCreateListener() {
        }

        public void onCreate(Transaction tx, ObjId id) {
            JClass<?> jclass;
            try {
                jclass = JTransaction.this.jdb.getJClass(id);
            }
            catch (TypeNotInSchemaVersionException e) {
                return;
            }
            this.doOnCreate(jclass, id);
        }

        private <T> void doOnCreate(JClass<T> jclass, ObjId id) {
            if (JTransaction.this.validationMode == ValidationMode.AUTOMATIC && jclass.requiresDefaultValidation) {
                JTransaction.this.revalidate(Collections.singleton(id), new Class[0]);
            }
            JObject jobj = null;
            for (MethodAnnotationScanner.MethodInfo info : jclass.onCreateMethods) {
                if (JTransaction.this instanceof SnapshotJTransaction && !((OnCreate)info.getAnnotation()).snapshotTransactions()) continue;
                if (jobj == null) {
                    jobj = JTransaction.this.get(id);
                }
                Util.invoke(info.getMethod(), jobj, new Object[0]);
            }
        }
    }
}

