/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.NavigableMap;
import org.jsimpledb.util.ConvertedNavigableMap;

class NavigableMapConverter<K, V, WK, WV>
extends Converter<NavigableMap<K, V>, NavigableMap<WK, WV>> {
    private final Converter<K, WK> keyConverter;
    private final Converter<V, WV> valueConverter;

    NavigableMapConverter(Converter<K, WK> keyConverter, Converter<V, WV> valueConverter) {
        Preconditions.checkArgument((keyConverter != null ? 1 : 0) != 0, (Object)"null keyConverter");
        Preconditions.checkArgument((valueConverter != null ? 1 : 0) != 0, (Object)"null valueConverter");
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    protected NavigableMap<WK, WV> doForward(NavigableMap<K, V> map) {
        if (map == null) {
            return null;
        }
        return new ConvertedNavigableMap(map, this.keyConverter.reverse(), this.valueConverter.reverse());
    }

    protected NavigableMap<K, V> doBackward(NavigableMap<WK, WV> map) {
        if (map == null) {
            return null;
        }
        return new ConvertedNavigableMap(map, this.keyConverter, this.valueConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        NavigableMapConverter that = (NavigableMapConverter)((Object)obj);
        return this.keyConverter.equals(that.keyConverter) && this.valueConverter.equals(that.valueConverter);
    }

    public int hashCode() {
        return this.keyConverter.hashCode() ^ this.valueConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[keyConverter=" + this.keyConverter + ",valueConverter=" + this.valueConverter + "]";
    }
}

