/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.groups.Default;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.MethodKey;
import org.jsimpledb.annotation.OnValidate;

public final class Util {
    private static final WildcardType QUESTION_MARK = new WildcardType(){

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{Object.class};
        }

        @Override
        public Type[] getLowerBounds() {
            return new Type[0];
        }

        public String toString() {
            return "?";
        }
    };
    private static Method newParameterizedTypeMethod;

    private Util() {
    }

    public static AnnotatedElement hasValidation(Class<?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        if (Util.hasValidationAnnotation(type)) {
            return type;
        }
        for (Method method : type.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) == 0 || !Util.hasValidationAnnotation(method)) continue;
            return method;
        }
        for (TypeToken typeToken : TypeToken.of(type).getTypes()) {
            AnnotatedElement annotatedElement;
            Class superType = typeToken.getRawType();
            if (superType == type || (annotatedElement = Util.hasValidation(superType)) == null) continue;
            return annotatedElement;
        }
        return null;
    }

    public static boolean requiresDefaultValidation(Class<?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        if (Util.hasDefaultValidationAnnotation(type)) {
            return true;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (method.isAnnotationPresent(OnValidate.class)) {
                return true;
            }
            if ((method.getModifiers() & 1) == 0 || !Util.requiresDefaultValidation(method)) continue;
            return true;
        }
        for (TypeToken typeToken : TypeToken.of(type).getTypes()) {
            Class superType = typeToken.getRawType();
            if (superType == type || !Util.requiresDefaultValidation(superType)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDefaultValidation(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"null method");
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (TypeToken typeToken : TypeToken.of(method.getDeclaringClass()).getTypes()) {
            Class superType = typeToken.getRawType();
            try {
                method = superType.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (!Util.hasDefaultValidationAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultValidationAnnotation(AnnotatedElement obj) {
        return Util.hasValidationAnnotation(obj, new Class[]{Default.class});
    }

    public static boolean hasValidationAnnotation(AnnotatedElement obj) {
        return Util.hasValidationAnnotation(obj, null);
    }

    private static boolean hasValidationAnnotation(AnnotatedElement obj, Class[] validationGroups) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0, (Object)"null obj");
        for (Annotation annotation : obj.getAnnotations()) {
            Class[] groups;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Constraint.class)) continue;
            try {
                groups = (Class[])annotation.getClass().getMethod("groups", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                return true;
            }
            if (groups == null || groups.length == 0) {
                return true;
            }
            return validationGroups == null || Util.isAnyGroupBeingValidated(groups, validationGroups);
        }
        return false;
    }

    public static boolean isGroupBeingValidated(Class<?> constraintGroup, Class<?>[] validationGroups) {
        Preconditions.checkArgument((constraintGroup != null ? 1 : 0) != 0, (Object)"null constraintGroup");
        Preconditions.checkArgument((validationGroups != null ? 1 : 0) != 0, (Object)"null validationGroups");
        for (Class<?> validationGroup : validationGroups) {
            Preconditions.checkArgument((validationGroup != null ? 1 : 0) != 0, (Object)"null validationGroup");
            if (!constraintGroup.isAssignableFrom(validationGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyGroupBeingValidated(Class<?>[] constraintGroups, Class<?>[] validationGroups) {
        Preconditions.checkArgument((constraintGroups != null ? 1 : 0) != 0, (Object)"null constraintGroups");
        for (Class<?> constraintGroup : constraintGroups) {
            if (!Util.isGroupBeingValidated(constraintGroup, validationGroups)) continue;
            return true;
        }
        return false;
    }

    static Method findJFieldSetterMethod(Class<?> type, Method getter) {
        Matcher matcher = Pattern.compile("(is|get)(.+)").matcher(getter.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("can't infer setter method name from getter method " + getter.getName() + "() because name does not follow Java bean naming conventions");
        }
        String setterName = "set" + matcher.group(2);
        for (TypeToken superType : TypeToken.of(type).getTypes()) {
            try {
                Method setter = superType.getRawType().getDeclaredMethod(setterName, getter.getReturnType());
                if (setter.getReturnType() != Void.TYPE) continue;
                if ((setter.getModifiers() & 5) == 0 || (setter.getModifiers() & 2) != 0) {
                    throw new IllegalArgumentException("invalid setter method " + setterName + "() corresponding to getter method " + getter.getName() + "(): method must be public or protected");
                }
                return setter;
            }
            catch (NoSuchMethodException e) {
            }
        }
        throw new IllegalArgumentException("can't find any setter method " + setterName + "() corresponding to getter method " + getter.getName() + "() taking " + getter.getReturnType() + " and returning void");
    }

    static Map<MethodKey, Method> findAbstractMethods(Class<?> type) {
        HashMap<MethodKey, Method> map = new HashMap<MethodKey, Method>();
        for (TypeToken superType : TypeToken.of(type).getTypes()) {
            for (Method method : superType.getRawType().getDeclaredMethods()) {
                MethodKey key = new MethodKey(method);
                if (map.containsKey(key)) continue;
                map.put(key, method);
            }
        }
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if ((((Method)entry.getValue()).getModifiers() & 0x400) != 0) continue;
            i.remove();
        }
        return map;
    }

    public static TypeToken<?> findLowestCommonAncestorOfClasses(Iterable<Class<?>> types) {
        return Util.findLowestCommonAncestor(Iterables.transform(types, (Function)new Function<Class<?>, TypeToken<?>>(){

            public TypeToken<?> apply(Class<?> type) {
                return TypeToken.of(type);
            }
        }));
    }

    public static TypeToken<?> findLowestCommonAncestor(Iterable<TypeToken<?>> types) {
        TypeToken supertype;
        HashSet supertypes = new HashSet();
        for (TypeToken<?> type : types) {
            Util.addSupertypes(supertypes, type);
        }
        Iterator<Object> i = supertypes.iterator();
        block5: while (i.hasNext()) {
            supertype = (TypeToken)i.next();
            for (TypeToken<?> type : types) {
                if (supertype.isAssignableFrom(type)) continue;
                i.remove();
                continue block5;
            }
        }
        i = supertypes.iterator();
        block7: while (i.hasNext()) {
            supertype = (TypeToken)i.next();
            for (TypeToken<?> supertype2 : supertypes) {
                if (supertype2 == supertype || !supertype.isAssignableFrom(supertype2)) continue;
                i.remove();
                continue block7;
            }
        }
        TypeToken objectType = TypeToken.of(Object.class);
        supertypes.remove(objectType);
        switch (supertypes.size()) {
            case 0: {
                return objectType;
            }
            case 1: {
                return supertypes.iterator().next();
            }
        }
        for (TypeToken<?> supertype2 : supertypes) {
            if (supertype2.getRawType().isInterface()) continue;
            return supertype2;
        }
        TypeToken jobjectType = TypeToken.of(JObject.class);
        if (supertypes.contains(jobjectType)) {
            return jobjectType;
        }
        return objectType;
    }

    private static <T> void addSupertypes(Set<TypeToken<?>> types, TypeToken<T> type) {
        if (type == null || !types.add(type)) {
            return;
        }
        Class rawType = type.getRawType();
        types.add(TypeToken.of((Class)rawType));
        types.add(Util.getWildcardedType(rawType));
        Class superclass = rawType.getSuperclass();
        if (superclass != null) {
            Util.addSupertypes(types, TypeToken.of(superclass));
            Util.addSupertypes(types, type.getSupertype(superclass));
        }
        for (Class<?> iface : rawType.getInterfaces()) {
            Util.addSupertypes(types, type.getSupertype(iface));
        }
    }

    public static <T> TypeToken<? extends T> getWildcardedType(Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        TypeVariable<Class<T>>[] typeVariables = type.getTypeParameters();
        if (typeVariables.length == 0) {
            return TypeToken.of(type);
        }
        Object[] questionMarks = new WildcardType[typeVariables.length];
        Arrays.fill(questionMarks, QUESTION_MARK);
        return Util.newParameterizedType(type, (Type[])questionMarks);
    }

    public static Type getTypeParameter(Type type, int index) {
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (Object)"type is missing generic type parameter(s)");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] parameters = parameterizedType.getActualTypeArguments();
        if (index >= parameters.length) {
            throw new IllegalArgumentException("type is missing generic type parameter(s)");
        }
        return parameters[index];
    }

    public static Object invoke(Method method, Object target, Object ... params) {
        try {
            return method.invoke(target, params);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new JSimpleDBException("unexpected error invoking method " + method + " on " + target, e);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSimpleDBException("unexpected error invoking method " + method + " on " + target, e);
        }
    }

    public static <T> TypeToken<? extends T> newParameterizedType(Class<T> target, Type[] params) {
        Type type;
        try {
            if (newParameterizedTypeMethod == null) {
                newParameterizedTypeMethod = Class.forName("com.google.common.reflect.Types", false, Thread.currentThread().getContextClassLoader()).getDeclaredMethod("newParameterizedType", Class.class, Type[].class);
                newParameterizedTypeMethod.setAccessible(true);
            }
            type = (Type)newParameterizedTypeMethod.invoke(null, target, params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return TypeToken.of((Type)type);
    }
}

