/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import com.google.common.base.Preconditions;
import org.jsimpledb.change.Change;

public abstract class FieldChange<T>
extends Change<T> {
    private final int storageId;
    private final String fieldName;

    protected FieldChange(T jobj, int storageId, String fieldName) {
        super(jobj);
        Preconditions.checkArgument((storageId > 0 ? 1 : 0) != 0, (Object)"storageId <= 0");
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0, (Object)"null fieldName");
        this.storageId = storageId;
        this.fieldName = fieldName;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FieldChange that = (FieldChange)obj;
        return this.storageId == that.storageId && this.fieldName.equals(that.fieldName);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.storageId ^ this.fieldName.hashCode();
    }
}

