/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.ListFieldChange;

public class ListFieldReplace<T, E>
extends ListFieldChange<T> {
    private final int index;
    private final E oldValue;
    private final E newValue;

    public ListFieldReplace(T jobj, int storageId, String fieldName, int index, E oldValue, E newValue) {
        super(jobj, storageId, fieldName);
        this.index = index;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseListFieldReplace(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readListField(jobj.getObjId(), this.getStorageId(), false).set(this.index, this.newValue);
    }

    public int getIndex() {
        return this.index;
    }

    public E getOldValue() {
        return this.oldValue;
    }

    public E getNewValue() {
        return this.newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ListFieldReplace that = (ListFieldReplace)obj;
        return this.index == that.index && (this.oldValue != null ? this.oldValue.equals(that.oldValue) : that.oldValue == null) && (this.newValue != null ? this.newValue.equals(that.newValue) : that.newValue == null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.index ^ (this.oldValue != null ? this.oldValue.hashCode() : 0) ^ (this.newValue != null ? this.newValue.hashCode() : 0);
    }

    public String toString() {
        return "ListFieldReplace[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",index=" + this.index + ",oldValue=" + this.oldValue + ",newValue=" + this.newValue + "]";
    }
}

