/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.MapFieldChange;

public class MapFieldRemove<T, K, V>
extends MapFieldChange<T> {
    private final K key;
    private final V value;

    public MapFieldRemove(T jobj, int storageId, String fieldName, K key, V value) {
        super(jobj, storageId, fieldName);
        this.key = key;
        this.value = value;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseMapFieldRemove(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readMapField(jobj.getObjId(), this.getStorageId(), false).remove(this.key);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapFieldRemove that = (MapFieldRemove)obj;
        return (this.key != null ? this.key.equals(that.key) : that.key == null) && (this.value != null ? this.value.equals(that.value) : that.value == null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
    }

    public String toString() {
        return "MapFieldRemove[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",key=" + this.key + ",value=" + this.value + "]";
    }
}

