/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.change;

import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.change.ChangeSwitch;
import org.jsimpledb.change.MapFieldChange;

public class MapFieldReplace<T, K, V>
extends MapFieldChange<T> {
    private final K key;
    private final V oldValue;
    private final V newValue;

    public MapFieldReplace(T jobj, int storageId, String fieldName, K key, V oldValue, V newValue) {
        super(jobj, storageId, fieldName);
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public <R> R visit(ChangeSwitch<R> target) {
        return target.caseMapFieldReplace(this);
    }

    @Override
    public void apply(JTransaction jtx, JObject jobj) {
        jtx.readMapField(jobj.getObjId(), this.getStorageId(), false).put(this.key, this.newValue);
    }

    public K getKey() {
        return this.key;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public V getNewValue() {
        return this.newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapFieldReplace that = (MapFieldReplace)obj;
        return (this.key != null ? this.key.equals(that.key) : that.key == null) && (this.oldValue != null ? this.oldValue.equals(that.oldValue) : that.oldValue == null) && (this.newValue != null ? this.newValue.equals(that.newValue) : that.newValue == null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.key != null ? this.key.hashCode() : 0) ^ (this.oldValue != null ? this.oldValue.hashCode() : 0) ^ (this.newValue != null ? this.newValue.hashCode() : 0);
    }

    public String toString() {
        return "MapFieldReplace[object=" + this.getObject() + ",field=\"" + this.getFieldName() + "\",key=" + this.key + ",oldValue=" + this.oldValue + ",newValue=" + this.newValue + "]";
    }
}

