/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.ObjIdSet;

public class CopyState
implements Cloneable {
    private final TreeMap<int[], ObjIdSet> traversedMap = new TreeMap(Ints.lexicographicalComparator());
    private ObjIdSet copied;

    public CopyState() {
        this(new ObjIdSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyState(ObjIdSet copied) {
        Preconditions.checkArgument((copied != null ? 1 : 0) != 0, (Object)"null copied");
        this.copied = copied.clone();
        CopyState copyState = this;
        synchronized (copyState) {
        }
    }

    public boolean markCopied(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        return this.copied.add(id);
    }

    public boolean markTraversed(ObjId id, int[] fields) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((fields != null ? 1 : 0) != 0, (Object)"null fields");
        Preconditions.checkArgument((fields.length > 0 ? 1 : 0) != 0, (Object)"empty fields");
        boolean fullPath = true;
        for (int limit = fields.length; limit > 0; --limit) {
            int[] prefix = fullPath ? fields : Arrays.copyOfRange(fields, 0, limit);
            ObjIdSet idSet = this.traversedMap.get(prefix);
            if (idSet == null) {
                idSet = new ObjIdSet();
                this.traversedMap.put(prefix, idSet);
            }
            if (!idSet.add(id)) {
                return !fullPath;
            }
            fullPath = false;
        }
        return true;
    }

    public CopyState clone() {
        CopyState clone;
        try {
            clone = (CopyState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<int[], ObjIdSet> entry : this.traversedMap.entrySet()) {
            clone.traversedMap.put(entry.getKey(), entry.getValue().clone());
        }
        clone.copied = this.copied.clone();
        return clone;
    }
}

