/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jsimpledb.StorageIdGenerator;

public class DefaultStorageIdGenerator
implements StorageIdGenerator {
    public static final int MIN_STORAGE_ID = 507;
    public static final int MAX_STORAGE_ID = 65787;
    private final MessageDigest sha1;

    public DefaultStorageIdGenerator() {
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int generateClassStorageId(Class<?> type, String name) {
        return this.getStorageId("class:" + name);
    }

    @Override
    public int generateCompositeIndexStorageId(Class<?> type, String name, int[] fields) {
        return this.getStorageId("index:" + name);
    }

    @Override
    public int generateFieldStorageId(Method getter, String name) {
        return this.getStorageId("field:" + name);
    }

    @Override
    public int generateSetElementStorageId(Method getter, String name) {
        return this.getStorageId("field:" + name + "." + "element");
    }

    @Override
    public int generateListElementStorageId(Method getter, String name) {
        return this.getStorageId("field:" + name + "." + "element");
    }

    @Override
    public int generateMapKeyStorageId(Method getter, String name) {
        return this.getStorageId("field:" + name + "." + "key");
    }

    @Override
    public int generateMapValueStorageId(Method getter, String name) {
        return this.getStorageId("field:" + name + "." + "value");
    }

    private int getStorageId(String string) {
        this.sha1.reset();
        byte[] digest = this.sha1.digest(string.getBytes(Charset.forName("UTF-8")));
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = value << 8 | digest[i] & 0xFF;
        }
        return (value &= Integer.MAX_VALUE) % 65280 + 507;
    }
}

