/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexFieldInfo;
import org.jsimpledb.JCompositeIndex;
import org.jsimpledb.JCompositeIndexInfo;
import org.jsimpledb.JMapFieldInfo;
import org.jsimpledb.JObject;
import org.jsimpledb.JReferenceFieldInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleFieldInfo;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.core.CoreIndex;
import org.jsimpledb.core.CoreIndex2;
import org.jsimpledb.core.CoreIndex3;
import org.jsimpledb.core.CoreIndex4;
import org.jsimpledb.kv.KeyFilter;
import org.jsimpledb.kv.KeyRanges;

class IndexInfo {
    private static final KeyRanges NULL_RANGE = new KeyRanges(new byte[]{-1}, null);
    final JSimpleFieldInfo fieldInfo;
    final JComplexFieldInfo superFieldInfo;
    final JCompositeIndexInfo indexInfo;
    private final Class<?> startType;
    private final ArrayList<KeyRanges> filters = new ArrayList();

    IndexInfo(JSimpleDB jdb, Class<?> startType, String fieldName, Class<?> valueType) {
        this(jdb, startType, fieldName, valueType, (Class<?>)null);
    }

    IndexInfo(JSimpleDB jdb, Class<?> startType, String fieldName, Class<?> valueType, Class<?> keyType) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0, (Object)"null fieldName");
        Preconditions.checkArgument((startType != null ? 1 : 0) != 0, (Object)"null startType");
        Preconditions.checkArgument((valueType != null ? 1 : 0) != 0, (Object)"null valueType");
        this.indexInfo = null;
        Preconditions.checkArgument((!startType.isPrimitive() && !startType.isArray() ? 1 : 0) != 0, (Object)("invalid startType " + startType));
        this.startType = startType;
        ReferencePath path = jdb.parseReferencePath(this.startType, fieldName, true);
        if (path.getReferenceFields().length > 0) {
            throw new IllegalArgumentException("invalid field name `" + fieldName + "': contains intermediate reference(s)");
        }
        if (!(path.targetFieldInfo instanceof JSimpleFieldInfo)) {
            throw new IllegalArgumentException(path.targetFieldInfo + " does not support indexing; it is not a simple field");
        }
        this.fieldInfo = (JSimpleFieldInfo)path.targetFieldInfo;
        this.superFieldInfo = path.targetSuperFieldInfo;
        if (!this.fieldInfo.isIndexed()) {
            throw new IllegalArgumentException(this.fieldInfo + " is not indexed");
        }
        ArrayList<ValueCheck> valueChecks = new ArrayList<ValueCheck>(3);
        valueChecks.add(new ValueCheck("value type", valueType, path.getTargetFieldType(), this.fieldInfo, true));
        valueChecks.add(new ValueCheck("target type", startType, path.targetType));
        if (keyType != null) {
            JMapFieldInfo mapInfo = (JMapFieldInfo)this.superFieldInfo;
            JSimpleFieldInfo keyInfo = mapInfo.getKeyFieldInfo();
            assert (this.fieldInfo.equals(mapInfo.getValueFieldInfo()));
            valueChecks.add(new ValueCheck("map key type", keyType, keyInfo.getTypeToken(this.startType), keyInfo, true));
        }
        for (ValueCheck check : valueChecks) {
            this.filters.add(check.checkAndGetKeyRanges(jdb, startType, "index query on field `" + fieldName + "'"));
        }
    }

    IndexInfo(JSimpleDB jdb, Class<?> startType, String indexName, Class<?> ... valueTypes) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((indexName != null ? 1 : 0) != 0, (Object)"null indexName");
        Preconditions.checkArgument((valueTypes != null ? 1 : 0) != 0, (Object)"null valueTypes");
        this.fieldInfo = null;
        this.superFieldInfo = null;
        Preconditions.checkArgument((!startType.isPrimitive() && !startType.isArray() ? 1 : 0) != 0, (Object)("invalid startType " + startType));
        this.startType = startType;
        this.indexInfo = IndexInfo.findCompositeIndex(jdb, startType, indexName, valueTypes.length);
        ArrayList<ValueCheck> valueChecks = new ArrayList<ValueCheck>(3);
        for (int i = 0; i < valueTypes.length; ++i) {
            Class<?> valueType = valueTypes[i];
            JSimpleFieldInfo jfieldInfo = this.indexInfo.jfieldInfos.get(i);
            valueChecks.add(new ValueCheck("value type #" + (i + 1), valueType, jfieldInfo.getTypeToken(this.startType), jfieldInfo instanceof JReferenceFieldInfo, true));
        }
        valueChecks.add(new ValueCheck("target type", startType, startType));
        for (ValueCheck check : valueChecks) {
            this.filters.add(check.checkAndGetKeyRanges(jdb, startType, "query on composite index `" + indexName + "'"));
        }
    }

    private static JCompositeIndexInfo findCompositeIndex(JSimpleDB jdb, Class<?> startType, String indexName, int numValues) {
        JCompositeIndexInfo indexInfo = null;
        for (JClass<?> jclass : jdb.getJClasses(startType)) {
            JCompositeIndex index = jclass.jcompositeIndexesByName.get(indexName);
            if (index == null) continue;
            JCompositeIndexInfo candidate = jdb.jcompositeIndexInfos.get(index.storageId);
            if (indexInfo != null && !candidate.equals(indexInfo)) {
                throw new IllegalArgumentException("ambiguous composite index name `" + indexName + "': multiple composite indexes with that name exist on sub-types of " + startType.getName());
            }
            indexInfo = candidate;
        }
        if (indexInfo == null) {
            throw new IllegalArgumentException("no composite index named `" + indexName + "' exists on any sub-type of " + startType.getName());
        }
        if (numValues != indexInfo.jfieldInfos.size()) {
            throw new IllegalArgumentException("composite index `" + indexName + "' on " + startType.getName() + " has " + indexInfo.jfieldInfos.size() + " fields, not " + numValues);
        }
        return indexInfo;
    }

    public <V, T> CoreIndex<V, T> applyFilters(CoreIndex<V, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, T> CoreIndex2<V1, V2, T> applyFilters(CoreIndex2<V1, V2, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, V3, T> CoreIndex3<V1, V2, V3, T> applyFilters(CoreIndex3<V1, V2, V3, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public <V1, V2, V3, V4, T> CoreIndex4<V1, V2, V3, V4, T> applyFilters(CoreIndex4<V1, V2, V3, V4, T> index) {
        for (int i = 0; i < this.filters.size(); ++i) {
            KeyRanges filter = this.filters.get(i);
            if (filter == null || filter.isFull()) continue;
            index = index.filter(i, (KeyFilter)filter);
        }
        return index;
    }

    public String toString() {
        return "IndexInfo[startType=" + this.startType + (this.fieldInfo != null ? ",fieldInfo=" + this.fieldInfo : "") + (this.superFieldInfo != null ? ",superFieldInfo=" + this.superFieldInfo : "") + (this.indexInfo != null ? ",indexInfo=" + this.indexInfo : "") + ",filters=" + this.filters + "]";
    }

    private static class ValueCheck {
        private final String description;
        private final Class<?> actualType;
        private final Class<?> expectedType;
        private final boolean reference;
        private final boolean matchNull;

        ValueCheck(String description, Class<?> actualType, TypeToken<?> expectedType, boolean reference, boolean matchNull) {
            this.description = description;
            this.actualType = actualType;
            this.expectedType = expectedType.wrap().getRawType();
            this.reference = reference;
            this.matchNull = matchNull;
        }

        ValueCheck(String description, Class<?> actualType, TypeToken<?> expectedType, JSimpleFieldInfo fieldInfo, boolean matchNull) {
            this(description, actualType, expectedType, fieldInfo instanceof JReferenceFieldInfo, matchNull);
        }

        ValueCheck(String description, Class<?> actualType, Class<?> expectedType) {
            this(description, actualType, TypeToken.of(expectedType), true, false);
        }

        public KeyRanges checkAndGetKeyRanges(JSimpleDB jdb, Class<?> startType, String queryDescription) {
            boolean comparable;
            boolean equal = this.expectedType.equals(this.actualType);
            boolean bl = comparable = equal || this.expectedType.isAssignableFrom(this.actualType) || this.actualType.isAssignableFrom(this.expectedType);
            if (!(!this.reference ? equal : comparable)) {
                throw new IllegalArgumentException("invalid " + this.description + " " + this.actualType.getName() + " for " + queryDescription + " in " + startType + ": should be " + (this.reference ? "a super-type or sub-type of " : "") + this.expectedType.getName());
            }
            if (!this.reference) {
                return null;
            }
            if (this.actualType.isAssignableFrom(JObject.class)) {
                return null;
            }
            KeyRanges filter = jdb.keyRangesFor(this.actualType);
            if (this.matchNull) {
                filter = filter.union(new KeyRanges[]{NULL_RANGE});
            }
            return filter;
        }
    }
}

