/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.CollectionSchemaField;

public abstract class JCollectionField
extends JComplexField {
    final JSimpleField elementField;

    JCollectionField(JSimpleDB jdb, String name, int storageId, JSimpleField elementField, String description, Method getter) {
        super(jdb, name, storageId, description, getter);
        Preconditions.checkArgument((elementField != null ? 1 : 0) != 0, (Object)"null elementField");
        this.elementField = elementField;
    }

    public JSimpleField getElementField() {
        return this.elementField;
    }

    @Override
    public abstract Collection<?> getValue(JObject var1);

    @Override
    public List<JSimpleField> getSubFields() {
        return Collections.singletonList(this.elementField);
    }

    @Override
    public JSimpleField getSubField(String name) {
        if ("element".equals(name)) {
            return this.elementField;
        }
        throw new IllegalArgumentException("unknown sub-field `" + name + "' (did you mean `" + "element" + "' instead?)");
    }

    @Override
    String getSubFieldName(JSimpleField subField) {
        if (subField == this.elementField) {
            return "element";
        }
        throw new IllegalArgumentException("unknown sub-field");
    }

    abstract CollectionSchemaField toSchemaItem(JSimpleDB var1);

    void initialize(JSimpleDB jdb, CollectionSchemaField schemaField) {
        super.initialize(jdb, (AbstractSchemaItem)schemaField);
        schemaField.setElementField(this.elementField.toSchemaItem(jdb));
    }
}

