/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import java.lang.reflect.Method;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JFieldInfo;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.Util;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.FieldVisitor;
import org.jsimpledb.asm.Label;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.schema.SchemaField;

public abstract class JField
extends JSchemaObject {
    final Method getter;
    JSchemaObject parent;
    boolean requiresDefaultValidation;

    JField(JSimpleDB jdb, String name, int storageId, String description, Method getter) {
        super(jdb, name, storageId, description);
        this.getter = getter;
    }

    void calculateRequiresDefaultValidation() {
        this.requiresDefaultValidation = this.getter != null && Util.requiresDefaultValidation(this.getter);
    }

    abstract SchemaField toSchemaItem(JSimpleDB var1);

    public Method getGetter() {
        return this.getter;
    }

    public abstract Object getValue(JObject var1);

    public abstract <R> R visit(JFieldSwitch<R> var1);

    abstract JFieldInfo toJFieldInfo();

    boolean hasClassInitializerBytecode() {
        return false;
    }

    void outputClassInitializerBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        throw new UnsupportedOperationException();
    }

    void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
    }

    abstract void outputMethods(ClassGenerator<?> var1, ClassWriter var2);

    void outputCachedValueField(ClassGenerator<?> generator, ClassWriter cw) {
        FieldVisitor valueField = cw.visitField(2, this.getCachedValueFieldName(), Type.getDescriptor(this.getCachedValueFieldType()), null, null);
        valueField.visitEnd();
    }

    void outputCachedValueGetterMethod(ClassGenerator<?> generator, ClassWriter cw, Method fieldReaderMethod) {
        MethodVisitor mv = generator.startMethod(cw, this.getter);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), this.getCachedValueFieldName(), Type.getDescriptor(this.getCachedValueFieldType()));
        mv.visitInsn(89);
        Label valueReady = new Label();
        mv.visitJumpInsn(199, valueReady);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$id", Type.getDescriptor(ObjId.class));
        mv.visitLdcInsn(this.storageId);
        mv.visitInsn(4);
        mv.visitMethodInsn(182, Type.getInternalName(JTransaction.class), fieldReaderMethod.getName(), Type.getMethodDescriptor(fieldReaderMethod), false);
        mv.visitTypeInsn(192, Type.getInternalName(this.getCachedValueFieldType()));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(95);
        mv.visitFieldInsn(181, generator.getClassName(), this.getCachedValueFieldName(), Type.getDescriptor(this.getCachedValueFieldType()));
        mv.visitLabel(valueReady);
        mv.visitFrame(4, 0, new Object[0], 1, new String[]{Type.getInternalName(this.getCachedValueFieldType())});
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private String getCachedValueFieldName() {
        return "$f" + this.storageId;
    }

    private Class<?> getCachedValueFieldType() {
        return this.getter.getReturnType();
    }
}

