/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.jsimpledb.AbstractFieldScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JFieldScanner;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.annotation.JMapField;

class JMapFieldScanner<T>
extends AbstractFieldScanner<T, JMapField> {
    JMapFieldScanner(JClass<T> jclass, boolean autogenFields, boolean autogenNonAbstract) {
        super(jclass, JMapField.class, autogenFields, autogenNonAbstract);
    }

    @Override
    protected JMapField getDefaultAnnotation() {
        return new JMapField(){

            public Class<JMapField> annotationType() {
                return JMapField.class;
            }

            @Override
            public String name() {
                return "";
            }

            @Override
            public int storageId() {
                return 0;
            }

            @Override
            public JField key() {
                return JFieldScanner.DEFAULT_JFIELD;
            }

            @Override
            public JField value() {
                return JFieldScanner.DEFAULT_JFIELD;
            }
        };
    }

    protected boolean includeMethod(Method method, JMapField annotation) {
        this.checkNotStatic(method);
        this.checkReturnType(method, Map.class, SortedMap.class, NavigableMap.class);
        this.checkParameterTypes(method, new TypeToken[0]);
        return true;
    }

    @Override
    protected boolean isAutoPropertyCandidate(Method method) {
        return super.isAutoPropertyCandidate(method) && Map.class.isAssignableFrom(method.getReturnType());
    }
}

