/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.TreeSet;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JClass;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JReferenceFieldInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferenceConverter;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.Label;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.DeleteAction;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ReferenceFieldType;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;

public class JReferenceField
extends JSimpleField {
    final DeleteAction onDelete;
    final boolean cascadeDelete;

    JReferenceField(JSimpleDB jdb, String name, int storageId, String description, TypeToken<?> typeToken, JField annotation, Method getter, Method setter) {
        super(jdb, name, storageId, typeToken, (FieldType<?>)new ReferenceFieldType(), true, annotation, description, getter, setter);
        this.onDelete = annotation.onDelete();
        this.cascadeDelete = annotation.cascadeDelete();
    }

    @Override
    public JObject getValue(JObject jobj) {
        return (JObject)super.getValue(jobj);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJReferenceField(this);
    }

    public Converter<ObjId, JObject> getConverter(JTransaction jtx) {
        return new ReferenceConverter<JObject>(jtx, JObject.class).reverse();
    }

    public DeleteAction getOnDelete() {
        return this.onDelete;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    ReferenceSchemaField toSchemaItem(JSimpleDB jdb) {
        ReferenceSchemaField schemaField = new ReferenceSchemaField();
        super.initialize(jdb, (SimpleSchemaField)schemaField);
        schemaField.setOnDelete(this.onDelete);
        schemaField.setCascadeDelete(this.cascadeDelete);
        TreeSet<Integer> objectTypes = new TreeSet<Integer>();
        for (JClass jclass : jdb.getJClasses(this.typeToken.getRawType())) {
            objectTypes.add(jclass.storageId);
        }
        schemaField.setObjectTypes(objectTypes);
        return schemaField;
    }

    @Override
    JReferenceFieldInfo toJFieldInfo(int parentStorageId) {
        return new JReferenceFieldInfo(this, parentStorageId);
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(this.getter.getModifiers() & 5, this.getter.getName(), Type.getMethodDescriptor(this.getter), null, generator.getExceptionNames(this.getter));
        this.outputReadCoreValueBytecode(generator, mv);
        mv.visitInsn(89);
        Label label1 = new Label();
        mv.visitJumpInsn(199, label1);
        mv.visitInsn(87);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(label1);
        mv.visitFrame(4, 0, new Object[0], 1, new String[]{Type.getInternalName(Object.class)});
        mv.visitTypeInsn(192, Type.getInternalName(ObjId.class));
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        mv.visitInsn(95);
        generator.emitInvoke(mv, ClassGenerator.GET_METHOD);
        mv.visitTypeInsn(192, Type.getInternalName(this.getter.getReturnType()));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(this.setter.getModifiers() & 5, this.setter.getName(), Type.getMethodDescriptor(this.setter), null, generator.getExceptionNames(this.setter));
        mv.visitVarInsn(25, 1);
        Label label2 = new Label();
        Label label3 = new Label();
        mv.visitJumpInsn(199, label2);
        mv.visitInsn(1);
        mv.visitJumpInsn(167, label3);
        mv.visitLabel(label2);
        mv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
        mv.visitVarInsn(25, 1);
        generator.emitInvoke(mv, ClassGenerator.JOBJECT_GET_OBJ_ID_METHOD);
        mv.visitLabel(label3);
        mv.visitFrame(4, 0, new Object[0], 1, new String[]{Type.getInternalName(ObjId.class)});
        this.outputWriteCoreValueBytecode(generator, mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

