/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.NavigableSet;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSetFieldInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.SetSchemaField;

public class JSetField
extends JCollectionField {
    JSetField(JSimpleDB jdb, String name, int storageId, JSimpleField elementField, String description, Method getter) {
        super(jdb, name, storageId, elementField, description, getter);
    }

    @Override
    public NavigableSet<?> getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readSetField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJSetField(this);
    }

    SetSchemaField toSchemaItem(JSimpleDB jdb) {
        SetSchemaField schemaField = new SetSchemaField();
        super.initialize(jdb, (CollectionSchemaField)schemaField);
        return schemaField;
    }

    @Override
    JSetFieldInfo toJFieldInfo() {
        return new JSetFieldInfo(this);
    }

    @Override
    Method getFieldReaderMethod() {
        return ClassGenerator.READ_SET_FIELD_METHOD;
    }
}

