/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleFieldInfo;
import org.jsimpledb.JTransaction;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SimpleSchemaField;

public class JSimpleField
extends JField {
    final TypeToken<?> typeToken;
    final FieldType<?> fieldType;
    final boolean indexed;
    final boolean unique;
    final ArrayList<Object> uniqueExcludes;
    final Method setter;

    JSimpleField(JSimpleDB jdb, String name, int storageId, TypeToken<?> typeToken, String typeName, boolean indexed, org.jsimpledb.annotation.JField annotation, String description, Method getter, Method setter) {
        this(jdb, name, storageId, typeToken, jdb.db.getFieldTypeRegistry().getFieldType(typeName), indexed, annotation, description, getter, setter);
    }

    JSimpleField(JSimpleDB jdb, String name, int storageId, TypeToken<?> typeToken, FieldType<?> fieldType, boolean indexed, org.jsimpledb.annotation.JField annotation, String description, Method getter, Method setter) {
        super(jdb, name, storageId, description, getter);
        Preconditions.checkArgument((typeToken != null ? 1 : 0) != 0, (Object)"null typeToken");
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        Preconditions.checkArgument((annotation != null ? 1 : 0) != 0, (Object)"null annotation");
        this.typeToken = typeToken;
        this.fieldType = fieldType;
        this.indexed = indexed;
        this.unique = annotation.unique();
        this.setter = setter;
        int numExcludes = annotation.uniqueExclude().length + (annotation.uniqueExcludeNull() ? 1 : 0);
        if (numExcludes > 0) {
            this.uniqueExcludes = new ArrayList(numExcludes);
            if (annotation.uniqueExcludeNull()) {
                this.uniqueExcludes.add(null);
            }
            for (String string : annotation.uniqueExclude()) {
                try {
                    this.uniqueExcludes.add(this.fieldType.fromString(string));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("invalid uniqueExclude() value `" + string + "': " + e.getMessage(), e);
                }
            }
            Collections.sort(this.uniqueExcludes, this.fieldType);
        } else {
            this.uniqueExcludes = null;
        }
    }

    public JComplexField getParentField() {
        return this.parent instanceof JComplexField ? (JComplexField)this.parent : null;
    }

    public TypeToken<?> getTypeToken() {
        return this.typeToken;
    }

    public FieldType<?> getFieldType() {
        return this.fieldType;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Method getSetter() {
        return this.setter;
    }

    @Override
    public Object getValue(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return jobj.getTransaction().readSimpleField(jobj.getObjId(), this.storageId, false);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJSimpleField(this);
    }

    public Converter<?, ?> getConverter(JTransaction jtx) {
        return Converter.identity();
    }

    public void setValue(JObject jobj, Object value) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        jobj.getTransaction().writeSimpleField(jobj, this.storageId, value, false);
    }

    SimpleSchemaField toSchemaItem(JSimpleDB jdb) {
        SimpleSchemaField schemaField = new SimpleSchemaField();
        this.initialize(jdb, schemaField);
        return schemaField;
    }

    @Override
    void calculateRequiresDefaultValidation() {
        super.calculateRequiresDefaultValidation();
        this.requiresDefaultValidation |= this.unique;
    }

    void initialize(JSimpleDB jdb, SimpleSchemaField schemaField) {
        super.initialize(jdb, (AbstractSchemaItem)schemaField);
        schemaField.setType(this.fieldType.getName());
        schemaField.setIndexed(this.indexed);
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        TypeToken propertyType = TypeToken.of(this.getter.getReturnType());
        MethodVisitor mv = cw.visitMethod(this.getter.getModifiers() & 5, this.getter.getName(), Type.getMethodDescriptor(this.getter), null, generator.getExceptionNames(this.getter));
        this.outputReadCoreValueBytecode(generator, mv);
        mv.visitTypeInsn(192, Type.getInternalName(propertyType.wrap().getRawType()));
        if (propertyType.isPrimitive()) {
            generator.unwrap(mv, Primitive.get((Class)propertyType.getRawType()));
        }
        mv.visitInsn(Type.getType(this.getter.getReturnType()).getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(this.setter.getModifiers() & 5, this.setter.getName(), Type.getMethodDescriptor(this.setter), null, generator.getExceptionNames(this.setter));
        mv.visitVarInsn(Type.getType(this.typeToken.getRawType()).getOpcode(21), 1);
        if (this.typeToken.isPrimitive()) {
            generator.wrap(mv, Primitive.get((Class)this.typeToken.getRawType()));
        }
        this.outputWriteCoreValueBytecode(generator, mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void outputReadCoreValueBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        TypeToken propertyType = TypeToken.of(this.getter.getReturnType());
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        generator.emitInvoke(mv, ClassGenerator.GET_TRANSACTION_METHOD);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$id", Type.getDescriptor(ObjId.class));
        mv.visitLdcInsn(this.storageId);
        mv.visitInsn(4);
        generator.emitInvoke(mv, ClassGenerator.TRANSACTION_READ_SIMPLE_FIELD_METHOD);
    }

    void outputWriteCoreValueBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        generator.emitInvoke(mv, ClassGenerator.REGISTER_JOBJECT_METHOD);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$tx", Type.getDescriptor(JTransaction.class));
        generator.emitInvoke(mv, ClassGenerator.GET_TRANSACTION_METHOD);
        mv.visitInsn(95);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, generator.getClassName(), "$id", Type.getDescriptor(ObjId.class));
        mv.visitInsn(95);
        mv.visitLdcInsn(this.storageId);
        mv.visitInsn(95);
        mv.visitInsn(4);
        generator.emitInvoke(mv, ClassGenerator.TRANSACTION_WRITE_SIMPLE_FIELD_METHOD);
    }

    @Override
    final JSimpleFieldInfo toJFieldInfo() {
        return this.toJFieldInfo(0);
    }

    JSimpleFieldInfo toJFieldInfo(int parentStorageId) {
        return new JSimpleFieldInfo(this, parentStorageId);
    }
}

