/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.HashSet;
import java.util.List;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldInfo;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.Util;
import org.jsimpledb.change.SimpleFieldChange;
import org.jsimpledb.core.SimpleFieldChangeListener;
import org.jsimpledb.core.Transaction;

class JSimpleFieldInfo
extends JFieldInfo {
    private final int parentStorageId;
    private boolean indexed;

    JSimpleFieldInfo(JSimpleField jfield, int parentStorageId) {
        super(jfield);
        this.parentStorageId = parentStorageId;
    }

    public int getParentStorageId() {
        return this.parentStorageId;
    }

    @Override
    public TypeToken<?> getTypeToken(Class<?> context) {
        HashSet contextFieldTypes = new HashSet();
        for (JClass<?> jclass : this.jdb.jclasses.values()) {
            JSimpleField jfield;
            if (!context.isAssignableFrom(jclass.type)) continue;
            if (this.parentStorageId != 0) {
                JComplexField parentField = (JComplexField)jclass.jfields.get(this.parentStorageId);
                if (parentField == null) continue;
                jfield = parentField.getSubField(this.storageId);
            } else {
                jfield = (JSimpleField)jclass.jfields.get(this.storageId);
                if (jfield == null) continue;
            }
            contextFieldTypes.add(jfield.typeToken);
        }
        if (contextFieldTypes.isEmpty()) {
            throw new IllegalArgumentException("no sub-type of " + context + " contains " + this);
        }
        return Util.findLowestCommonAncestor(contextFieldTypes);
    }

    @Override
    void witness(JField jfield) {
        super.witness(jfield);
        JSimpleField jsimpleField = (JSimpleField)jfield;
        this.indexed |= jsimpleField.indexed;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    void registerChangeListener(Transaction tx, int[] path, Iterable<Integer> types, AllChangesListener listener) {
        tx.addSimpleFieldChangeListener(this.storageId, path, types, (SimpleFieldChangeListener)listener);
    }

    @Override
    <T> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType) {
        this.addChangeParameterTypes(types, targetType, this.getTypeToken(targetType));
    }

    private <T, V> void addChangeParameterTypes(List<TypeToken<?>> types, Class<T> targetType, TypeToken<V> fieldType) {
        types.add(new TypeToken<SimpleFieldChange<T, V>>(){}.where(new TypeParameter<T>(){}, targetType).where(new TypeParameter<V>(){}, fieldType.wrap()));
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (this.parentStorageId != 0) {
            string = string.replaceAll(" field", " sub-field");
        }
        return string;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        JSimpleFieldInfo that = (JSimpleFieldInfo)obj;
        return this.parentStorageId == that.parentStorageId;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parentStorageId;
    }
}

