/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.AnnotationScanner;
import org.jsimpledb.JClass;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.Util;
import org.jsimpledb.annotation.OnChange;
import org.jsimpledb.change.FieldChange;
import org.jsimpledb.change.ListFieldAdd;
import org.jsimpledb.change.ListFieldClear;
import org.jsimpledb.change.ListFieldRemove;
import org.jsimpledb.change.ListFieldReplace;
import org.jsimpledb.change.MapFieldAdd;
import org.jsimpledb.change.MapFieldClear;
import org.jsimpledb.change.MapFieldRemove;
import org.jsimpledb.change.MapFieldReplace;
import org.jsimpledb.change.SetFieldAdd;
import org.jsimpledb.change.SetFieldClear;
import org.jsimpledb.change.SetFieldRemove;
import org.jsimpledb.change.SimpleFieldChange;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.ListField;
import org.jsimpledb.core.MapField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SetField;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.core.Transaction;

class OnChangeScanner<T>
extends AnnotationScanner<T, OnChange> {
    OnChangeScanner(JClass<T> jclass) {
        super(jclass, OnChange.class);
    }

    protected boolean includeMethod(Method method, OnChange annotation) {
        this.checkReturnType(method, Void.TYPE);
        if (this.getParameterTypeTokens(method).size() > 1) {
            throw new IllegalArgumentException(this.getErrorPrefix(method) + "method is required to take zero or one parameter");
        }
        return true;
    }

    protected ChangeMethodInfo createMethodInfo(Method method, OnChange annotation) {
        return new ChangeMethodInfo(method, annotation);
    }

    static class ChangeMethodListener
    implements AllChangesListener {
        private final JTransaction jtx;
        private final Method method;
        private final Class<?>[] genericTypes;

        ChangeMethodListener(JTransaction jtx, Method method) {
            Preconditions.checkArgument((jtx != null ? 1 : 0) != 0, (Object)"null jtx");
            Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"null method");
            this.jtx = jtx;
            this.method = method;
            switch (this.method.getParameterTypes().length) {
                case 1: {
                    ArrayList<Class> genericTypeList = new ArrayList<Class>(3);
                    for (Type type : ((ParameterizedType)this.method.getGenericParameterTypes()[0]).getActualTypeArguments()) {
                        genericTypeList.add(TypeToken.of((Type)type).getRawType());
                    }
                    this.genericTypes = genericTypeList.toArray(new Class[genericTypeList.size()]);
                    break;
                }
                case 0: {
                    this.genericTypes = null;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }

        public <T> void onSimpleFieldChange(Transaction tx, ObjId id, SimpleField<T> field, int[] path, NavigableSet<ObjId> referrers, T oldValue, T newValue) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object joldValue = this.jtx.convertCoreValue((Field<?>)field, oldValue);
            Object jnewValue = this.jtx.convertCoreValue((Field<?>)field, newValue);
            JObject jobj = this.checkTypes(SimpleFieldChange.class, id, joldValue, jnewValue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new SimpleFieldChange<JObject, Object>(jobj, field.getStorageId(), field.getName(), joldValue, jnewValue));
        }

        public <E> void onSetFieldAdd(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), value);
            JObject jobj = this.checkTypes(SetFieldAdd.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new SetFieldAdd<JObject, Object>(jobj, field.getStorageId(), field.getName(), jvalue));
        }

        public <E> void onSetFieldRemove(Transaction tx, ObjId id, SetField<E> field, int[] path, NavigableSet<ObjId> referrers, E value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), value);
            JObject jobj = this.checkTypes(SetFieldRemove.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new SetFieldRemove<JObject, Object>(jobj, field.getStorageId(), field.getName(), jvalue));
        }

        public void onSetFieldClear(Transaction tx, ObjId id, SetField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            JObject jobj = this.checkTypes(SetFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new SetFieldClear<JObject>(jobj, field.getStorageId(), field.getName()));
        }

        public <E> void onListFieldAdd(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), value);
            JObject jobj = this.checkTypes(ListFieldAdd.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new ListFieldAdd<JObject, Object>(jobj, field.getStorageId(), field.getName(), index, jvalue));
        }

        public <E> void onListFieldRemove(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), value);
            JObject jobj = this.checkTypes(ListFieldRemove.class, id, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new ListFieldRemove<JObject, Object>(jobj, field.getStorageId(), field.getName(), index, jvalue));
        }

        public <E> void onListFieldReplace(Transaction tx, ObjId id, ListField<E> field, int[] path, NavigableSet<ObjId> referrers, int index, E oldValue, E newValue) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object joldValue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), oldValue);
            Object jnewValue = this.jtx.convertCoreValue((Field<?>)field.getElementField(), newValue);
            JObject jobj = this.checkTypes(ListFieldReplace.class, id, joldValue, jnewValue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new ListFieldReplace<JObject, Object>(jobj, field.getStorageId(), field.getName(), index, joldValue, jnewValue));
        }

        public void onListFieldClear(Transaction tx, ObjId id, ListField<?> field, int[] path, NavigableSet<ObjId> referrers) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            JObject jobj = this.checkTypes(ListFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new ListFieldClear<JObject>(jobj, field.getStorageId(), field.getName()));
        }

        public <K, V> void onMapFieldAdd(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jkey = this.jtx.convertCoreValue((Field<?>)field.getKeyField(), key);
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getValueField(), value);
            JObject jobj = this.checkTypes(MapFieldAdd.class, id, jkey, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new MapFieldAdd<JObject, Object, Object>(jobj, field.getStorageId(), field.getName(), jkey, jvalue));
        }

        public <K, V> void onMapFieldRemove(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V value) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jkey = this.jtx.convertCoreValue((Field<?>)field.getKeyField(), key);
            Object jvalue = this.jtx.convertCoreValue((Field<?>)field.getValueField(), value);
            JObject jobj = this.checkTypes(MapFieldRemove.class, id, jkey, jvalue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new MapFieldRemove<JObject, Object, Object>(jobj, field.getStorageId(), field.getName(), jkey, jvalue));
        }

        public <K, V> void onMapFieldReplace(Transaction tx, ObjId id, MapField<K, V> field, int[] path, NavigableSet<ObjId> referrers, K key, V oldValue, V newValue) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            Object jkey = this.jtx.convertCoreValue((Field<?>)field.getKeyField(), key);
            Object joldValue = this.jtx.convertCoreValue((Field<?>)field.getValueField(), oldValue);
            Object jnewValue = this.jtx.convertCoreValue((Field<?>)field.getValueField(), newValue);
            JObject jobj = this.checkTypes(MapFieldReplace.class, id, jkey, joldValue, jnewValue);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new MapFieldReplace<JObject, Object, Object>(jobj, field.getStorageId(), field.getName(), jkey, joldValue, jnewValue));
        }

        public void onMapFieldClear(Transaction tx, ObjId id, MapField<?, ?> field, int[] path, NavigableSet<ObjId> referrers) {
            if (this.genericTypes == null) {
                this.invoke(referrers);
                return;
            }
            JObject jobj = this.checkTypes(MapFieldClear.class, id, new Object[0]);
            if (jobj == null) {
                return;
            }
            this.invoke(referrers, new MapFieldClear<JObject>(jobj, field.getStorageId(), field.getName()));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ChangeMethodListener that = (ChangeMethodListener)obj;
            return this.method.equals(that.method) && this.jtx.equals(that.jtx);
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.jtx.hashCode();
        }

        private JObject checkTypes(Class<?> changeType, ObjId id, Object ... values) {
            if (!this.method.getParameterTypes()[0].isAssignableFrom(changeType)) {
                return null;
            }
            JObject jobj = this.jtx.get(id);
            if (!this.genericTypes[0].isInstance(jobj)) {
                return null;
            }
            for (int i = 1; i < this.genericTypes.length; ++i) {
                Object value = values[Math.min(i, values.length) - 1];
                if (value == null || this.genericTypes[i].isInstance(value)) continue;
                return null;
            }
            return jobj;
        }

        private void invoke(NavigableSet<ObjId> referrers) {
            if ((this.method.getModifiers() & 8) != 0) {
                Util.invoke(this.method, null, new Object[0]);
            } else {
                for (ObjId id : referrers) {
                    JObject target = this.jtx.get(id);
                    if (!this.method.getDeclaringClass().isInstance(target)) continue;
                    Util.invoke(this.method, target, new Object[0]);
                }
            }
        }

        private void invoke(NavigableSet<ObjId> referrers, FieldChange<JObject> change) {
            assert (change != null);
            if ((this.method.getModifiers() & 8) != 0) {
                Util.invoke(this.method, null, change);
            } else {
                for (ObjId id : referrers) {
                    JObject target = this.jtx.get(id);
                    if (!this.method.getDeclaringClass().isInstance(target)) continue;
                    Util.invoke(this.method, target, change);
                }
            }
        }
    }

    class ChangeMethodInfo
    extends MethodAnnotationScanner.MethodInfo {
        final boolean isStatic;
        final HashMap<ReferencePath, HashSet<Integer>> paths;

        ChangeMethodInfo(Method method, OnChange annotation) {
            TypeToken<?> genericParameterType;
            Class<?> rawParameterType;
            List stringPaths;
            boolean wildcard;
            super((MethodAnnotationScanner)OnChangeScanner.this, method, (Annotation)annotation);
            this.isStatic = (method.getModifiers() & 8) != 0;
            Class<?> startType = method.getDeclaringClass();
            if (annotation.startType() != Void.TYPE) {
                if (!this.isStatic) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "startType() may only be used for annotations on static methods");
                }
                if (annotation.startType().isPrimitive() || annotation.startType().isArray()) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "invalid startType() " + annotation.startType());
                }
                startType = annotation.startType();
            }
            if (wildcard = (stringPaths = Arrays.asList(annotation.value())).isEmpty()) {
                stringPaths = Lists.transform((List)Lists.newArrayList(OnChangeScanner.this.jclass.jfields.values()), (Function)new Function<JField, String>(){

                    public String apply(JField jfield) {
                        return jfield.name + "#" + jfield.storageId;
                    }
                });
            }
            switch (method.getParameterTypes().length) {
                case 1: {
                    rawParameterType = method.getParameterTypes()[0];
                    genericParameterType = OnChangeScanner.this.getParameterTypeTokens(method).get(0);
                    break;
                }
                case 0: {
                    rawParameterType = null;
                    genericParameterType = null;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            boolean anyFieldsFound = false;
            this.paths = new HashMap(stringPaths.size());
            for (int i = 0; i < stringPaths.size(); ++i) {
                ReferencePath path;
                String stringPath = (String)stringPaths.get(i);
                try {
                    path = OnChangeScanner.this.jclass.jdb.parseReferencePath(startType, stringPath, false);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + e.getMessage(), e);
                }
                if (rawParameterType != null) {
                    ArrayList changeParameterTypes = new ArrayList();
                    try {
                        path.targetFieldInfo.addChangeParameterTypes(changeParameterTypes, path.targetType);
                    }
                    catch (UnsupportedOperationException e) {
                        if (wildcard) continue;
                        throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "path `" + stringPath + "' is invalid because change notifications are not supported for " + path.targetFieldInfo, e);
                    }
                    anyFieldsFound = true;
                    boolean anyChangeMatch = false;
                    for (TypeToken<?> possibleChangeType : changeParameterTypes) {
                        boolean matchesRaw;
                        boolean matchesGeneric = genericParameterType.isAssignableFrom(possibleChangeType);
                        if (matchesGeneric != (matchesRaw = rawParameterType.isAssignableFrom(possibleChangeType.getRawType()))) {
                            throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "method parameter type " + genericParameterType + " will match changes emitted from `" + stringPath + "' at runtime" + " due to type erasure, but has incompatible generic type " + genericParameterType + "; parameter type should be compatible with " + (changeParameterTypes.size() != 1 ? "one of: " + changeParameterTypes : (Serializable)changeParameterTypes.get(0)));
                        }
                        if (!matchesGeneric) continue;
                        anyChangeMatch = true;
                        break;
                    }
                    if (!anyChangeMatch) {
                        if (wildcard) continue;
                        throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "path `" + stringPath + "' is invalid because no changes emitted by " + path.targetFieldInfo + " match the method's" + " parameter type " + genericParameterType + "; the emitted change type is " + (changeParameterTypes.size() != 1 ? "one of: " + changeParameterTypes : (Serializable)changeParameterTypes.get(0)));
                    }
                }
                HashSet<Integer> storageIds = new HashSet<Integer>();
                for (JClass<?> jclass : OnChangeScanner.this.jclass.jdb.getJClasses(path.targetType)) {
                    storageIds.add(jclass.storageId);
                }
                this.paths.put(path, storageIds);
            }
            if (this.paths.isEmpty()) {
                if (!anyFieldsFound) {
                    throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "there are no fields that will generate change events");
                }
                throw new IllegalArgumentException(OnChangeScanner.this.getErrorPrefix(method) + "no changes emitted by any field" + " will match the method's parameter type " + genericParameterType);
            }
        }

        void registerChangeListener(JTransaction jtx) {
            ChangeMethodListener listener = new ChangeMethodListener(jtx, this.getMethod());
            for (Map.Entry<ReferencePath, HashSet<Integer>> entry : this.paths.entrySet()) {
                ReferencePath path = entry.getKey();
                HashSet<Integer> objectTypeStorageIds = entry.getValue();
                path.targetFieldInfo.registerChangeListener(jtx.tx, path.getReferenceFields(), objectTypeStorageIds, listener);
            }
        }
    }
}

