/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jsimpledb.JClass;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JComplexFieldInfo;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldInfo;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JReferenceFieldInfo;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Util;
import org.jsimpledb.util.CastFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePath {
    final Class<?> startType;
    final Class<?> targetType;
    final JFieldInfo targetFieldInfo;
    final JComplexFieldInfo targetSuperFieldInfo;
    final ArrayList<JReferenceFieldInfo> referenceFieldInfos = new ArrayList();
    final String path;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    ReferencePath(JSimpleDB jdb, Class<?> startType, String path, Boolean lastIsSubField) {
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        Preconditions.checkArgument((startType != null ? 1 : 0) != 0, (Object)"null startType");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"null path");
        String errorPrefix = "invalid path `" + path + "': ";
        if (path.length() == 0) {
            throw new IllegalArgumentException(errorPrefix + "path is empty");
        }
        this.startType = startType;
        this.path = path;
        ArrayDeque<String> fieldNames = new ArrayDeque<String>();
        while (true) {
            int dot;
            if ((dot = path.indexOf(46)) == -1) {
                if (path.length() == 0) {
                    throw new IllegalArgumentException(errorPrefix + "ends in `.'");
                }
                break;
            }
            if (dot == 0) {
                throw new IllegalArgumentException(errorPrefix + "contains an empty path component");
            }
            fieldNames.add(path.substring(0, dot));
            path = path.substring(dot + 1);
        }
        fieldNames.add(path);
        Class currentType = this.startType;
        JFieldInfo fieldInfo = null;
        JComplexFieldInfo superFieldInfo = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: START: startType=" + this.startType + " path=" + fieldNames + " lastIsSubField=" + lastIsSubField);
        }
        ArrayList storageIds = new ArrayList();
        assert (!fieldNames.isEmpty());
        while (!fieldNames.isEmpty()) {
            String searchName;
            String fieldName = (String)fieldNames.removeFirst();
            String description = "field `" + fieldName + "' in type " + currentType;
            int hash = fieldName.indexOf(35);
            int explicitStorageId = 0;
            if (hash != -1) {
                try {
                    explicitStorageId = Integer.parseInt(fieldName.substring(hash + 1));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(errorPrefix + "invalid field name `" + fieldName + "'");
                }
                searchName = fieldName.substring(0, hash);
            } else {
                searchName = fieldName;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath: [" + searchName + "] currentType=" + currentType + " storageId=" + explicitStorageId);
            }
            HashMap matchingFields = new HashMap();
            for (JClass<?> jclass : jdb.jclasses.values()) {
                JField jfield;
                if (!currentType.isAssignableFrom(jclass.type) || (jfield = jclass.jfieldsByName.get(searchName)) == null || explicitStorageId != 0 && jfield.storageId != explicitStorageId) continue;
                matchingFields.put(jclass, jfield);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath: matching fields: " + matchingFields);
            }
            if (matchingFields.isEmpty()) {
                throw new IllegalArgumentException(errorPrefix + "there is no field named `" + searchName + "'" + (explicitStorageId != 0 ? " with storage ID " + explicitStorageId : "") + " in (any sub-type of) " + currentType);
            }
            int fieldStorageId = ((JField)matchingFields.values().iterator().next()).storageId;
            for (JField jfield : matchingFields.values()) {
                if (jfield.storageId == fieldStorageId) continue;
                throw new IllegalArgumentException(errorPrefix + "there are multiple, non-equal fields named `" + fieldName + "' in sub-types of type " + currentType);
            }
            fieldInfo = jdb.getJFieldInfo(fieldStorageId, JFieldInfo.class);
            currentType = Util.findLowestCommonAncestorOfClasses(Iterables.transform(matchingFields.keySet(), (Function)new JClassTypeFunction())).getRawType();
            if (this.log.isTraceEnabled()) {
                this.log.trace("RefPath: updated currentType=" + currentType + " fieldType=" + fieldInfo.getTypeToken(currentType));
            }
            superFieldInfo = null;
            if (fieldInfo instanceof JComplexFieldInfo) {
                JComplexFieldInfo complexFieldInfo = (JComplexFieldInfo)fieldInfo;
                if (fieldNames.isEmpty()) {
                    if (lastIsSubField == null || !lastIsSubField.booleanValue()) break;
                    throw new IllegalArgumentException(errorPrefix + "path may not end on complex " + description + "; a sub-field of must be specified");
                }
                superFieldInfo = complexFieldInfo;
                String subFieldName = (String)fieldNames.removeFirst();
                description = "sub-field `" + subFieldName + "' of complex " + description;
                try {
                    fieldInfo = complexFieldInfo.getSubFieldInfo(subFieldName);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(errorPrefix + "invalid " + description + ": " + e.getMessage(), e);
                }
                for (Map.Entry entry : matchingFields.entrySet()) {
                    entry.setValue(((JComplexField)entry.getValue()).getSubField(subFieldName));
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("RefPath: [" + searchName + "." + subFieldName + "] new matching fields=" + matchingFields);
                }
            }
            if (fieldNames.isEmpty()) {
                if (superFieldInfo == null || !Boolean.FALSE.equals(lastIsSubField)) break;
                throw new IllegalArgumentException(errorPrefix + "path may not end on " + description + "; specify the complex field itself instead");
            }
            if (!(fieldInfo instanceof JReferenceFieldInfo)) {
                throw new IllegalArgumentException(errorPrefix + description + " is not a reference field");
            }
            JReferenceFieldInfo referenceFieldInfo = (JReferenceFieldInfo)fieldInfo;
            this.referenceFieldInfos.add(referenceFieldInfo);
            currentType = Util.findLowestCommonAncestor(Iterables.transform((Iterable)Iterables.transform(matchingFields.values(), (Function)new CastFunction(JReferenceField.class)), (Function)new JReferenceFieldTypeFunction())).getRawType();
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("RefPath: step through reference, new currentType=" + currentType);
        }
        this.targetType = currentType;
        this.targetFieldInfo = fieldInfo;
        this.targetSuperFieldInfo = superFieldInfo;
        if (this.log.isTraceEnabled()) {
            this.log.trace("RefPath: DONE: targetType=" + this.targetType + " targetFieldInfo=" + this.targetFieldInfo + " targetSuperFieldInfo=" + this.targetSuperFieldInfo + " targetFieldType=" + this.getTargetFieldType() + " references=" + this.referenceFieldInfos);
        }
    }

    public Class<?> getStartType() {
        return this.startType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public TypeToken<?> getTargetFieldType() {
        return this.targetFieldInfo.getTypeToken(this.targetType);
    }

    public int getTargetField() {
        return this.targetFieldInfo.storageId;
    }

    public int getTargetSuperField() {
        return this.targetSuperFieldInfo != null ? this.targetSuperFieldInfo.storageId : 0;
    }

    public int[] getReferenceFields() {
        int[] storageIds = new int[this.referenceFieldInfos.size()];
        for (int i = 0; i < storageIds.length; ++i) {
            storageIds[i] = this.referenceFieldInfos.get((int)i).storageId;
        }
        return storageIds;
    }

    public String toString() {
        return this.path;
    }

    private static class JClassTypeFunction
    implements Function<JClass<?>, Class<?>> {
        private JClassTypeFunction() {
        }

        public Class<?> apply(JClass<?> jclass) {
            return jclass.type;
        }
    }

    private static class JReferenceFieldTypeFunction
    implements Function<JReferenceField, TypeToken<?>> {
        private JReferenceFieldTypeFunction() {
        }

        public TypeToken<?> apply(JReferenceField jfield) {
            return jfield.typeToken;
        }
    }
}

