/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.scanner;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.flow.ApiFlow;
import org.jsondoc.core.pojo.ApiDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiObjectDoc;
import org.jsondoc.core.pojo.JSONDoc;
import org.jsondoc.core.pojo.JSONDocTemplate;
import org.jsondoc.core.pojo.flow.ApiFlowDoc;
import org.jsondoc.core.pojo.global.ApiGlobalDoc;
import org.jsondoc.core.scanner.JSONDocScanner;
import org.jsondoc.core.scanner.builder.JSONDocApiAuthDocBuilder;
import org.jsondoc.core.scanner.builder.JSONDocApiErrorDocBuilder;
import org.jsondoc.core.scanner.builder.JSONDocApiGlobalDocBuilder;
import org.jsondoc.core.scanner.builder.JSONDocApiVersionDocBuilder;
import org.jsondoc.core.scanner.validator.JSONDocApiMethodDocValidator;
import org.jsondoc.core.scanner.validator.JSONDocApiObjectDocValidator;
import org.jsondoc.core.util.JSONDocTemplateBuilder;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJSONDocScanner
implements JSONDocScanner {
    protected Reflections reflections = null;
    protected static Logger log = LoggerFactory.getLogger(JSONDocScanner.class);
    protected List<ApiMethodDoc> allApiMethodDocs = new ArrayList<ApiMethodDoc>();
    protected Set<Class<?>> jsondocControllers = new LinkedHashSet();
    protected Set<Method> jsondocMethods = new LinkedHashSet<Method>();
    protected Set<Class<?>> jsondocObjects = new LinkedHashSet();
    protected Map<Class<?>, JSONDocTemplate> jsondocTemplates = new HashMap();
    protected Set<Class<?>> jsondocFlows = new LinkedHashSet();
    protected Set<Class<?>> jsondocGlobal = new LinkedHashSet();
    protected Set<Class<?>> jsondocChangelogs = new LinkedHashSet();
    protected Set<Class<?>> jsondocMigrations = new LinkedHashSet();

    public abstract Set<Class<?>> jsondocControllers();

    public abstract Set<Method> jsondocMethods(Class<?> var1);

    public abstract Set<Class<?>> jsondocObjects(List<String> var1);

    public abstract Set<Class<?>> jsondocFlows();

    public abstract Set<Class<?>> jsondocGlobal();

    public abstract Set<Class<?>> jsondocChangelogs();

    public abstract Set<Class<?>> jsondocMigrations();

    public abstract ApiDoc initApiDoc(Class<?> var1);

    public abstract ApiDoc mergeApiDoc(Class<?> var1, ApiDoc var2);

    public abstract ApiMethodDoc initApiMethodDoc(Method var1, Map<Class<?>, JSONDocTemplate> var2);

    public abstract ApiMethodDoc mergeApiMethodDoc(Method var1, ApiMethodDoc var2);

    public abstract ApiObjectDoc initApiObjectDoc(Class<?> var1);

    public abstract ApiObjectDoc mergeApiObjectDoc(Class<?> var1, ApiObjectDoc var2);

    @Override
    public JSONDoc getJSONDoc(String version, String basePath, List<String> packages, boolean playgroundEnabled, JSONDoc.MethodDisplay displayMethodAs) {
        HashSet urls = new HashSet();
        FilterBuilder filter = new FilterBuilder();
        log.debug("Found " + packages.size() + " package(s) to scan...");
        for (String pkg : packages) {
            log.debug("Adding package to JSONDoc recursive scan: " + pkg);
            urls.addAll(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            filter.includePackage(new String[]{pkg});
        }
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)filter).setUrls(urls).addScanners(new Scanner[]{new MethodAnnotationsScanner()}));
        JSONDoc jsondocDoc = new JSONDoc(version, basePath);
        jsondocDoc.setPlaygroundEnabled(playgroundEnabled);
        jsondocDoc.setDisplayMethodAs(displayMethodAs);
        this.jsondocControllers = this.jsondocControllers();
        this.jsondocObjects = this.jsondocObjects(packages);
        this.jsondocFlows = this.jsondocFlows();
        this.jsondocGlobal = this.jsondocGlobal();
        this.jsondocChangelogs = this.jsondocChangelogs();
        this.jsondocMigrations = this.jsondocMigrations();
        for (Class<?> clazz : this.jsondocObjects) {
            this.jsondocTemplates.put(clazz, JSONDocTemplateBuilder.build(clazz, this.jsondocObjects));
        }
        jsondocDoc.setApis(this.getApiDocsMap(this.jsondocControllers, displayMethodAs));
        jsondocDoc.setObjects(this.getApiObjectsMap(this.jsondocObjects));
        jsondocDoc.setFlows(this.getApiFlowDocsMap(this.jsondocFlows, this.allApiMethodDocs));
        jsondocDoc.setGlobal(this.getApiGlobalDoc(this.jsondocGlobal, this.jsondocChangelogs, this.jsondocMigrations));
        return jsondocDoc;
    }

    @Override
    public ApiGlobalDoc getApiGlobalDoc(Set<Class<?>> global, Set<Class<?>> changelogs, Set<Class<?>> migrations) {
        return JSONDocApiGlobalDocBuilder.build(global, changelogs, migrations);
    }

    @Override
    public Set<ApiDoc> getApiDocs(Set<Class<?>> classes, JSONDoc.MethodDisplay displayMethodAs) {
        TreeSet<ApiDoc> apiDocs = new TreeSet<ApiDoc>();
        for (Class<?> controller : classes) {
            ApiDoc apiDoc = this.getApiDoc(controller, displayMethodAs);
            apiDocs.add(apiDoc);
        }
        return apiDocs;
    }

    private ApiDoc getApiDoc(Class<?> controller, JSONDoc.MethodDisplay displayMethodAs) {
        log.debug("Getting JSONDoc for class: " + controller.getName());
        ApiDoc apiDoc = this.initApiDoc(controller);
        apiDoc.setSupportedversions(JSONDocApiVersionDocBuilder.build(controller));
        apiDoc.setAuth(JSONDocApiAuthDocBuilder.getApiAuthDocForController(controller));
        apiDoc.setMethods(this.getApiMethodDocs(controller, displayMethodAs));
        if (controller.isAnnotationPresent(Api.class)) {
            apiDoc = this.mergeApiDoc(controller, apiDoc);
        }
        return apiDoc;
    }

    private Set<ApiMethodDoc> getApiMethodDocs(Class<?> controller, JSONDoc.MethodDisplay displayMethodAs) {
        TreeSet<ApiMethodDoc> apiMethodDocs = new TreeSet<ApiMethodDoc>();
        Set<Method> methods = this.jsondocMethods(controller);
        for (Method method : methods) {
            ApiMethodDoc apiMethodDoc = this.getApiMethodDoc(method, controller, displayMethodAs);
            apiMethodDocs.add(apiMethodDoc);
        }
        this.jsondocMethods.addAll(methods);
        this.allApiMethodDocs.addAll(apiMethodDocs);
        return apiMethodDocs;
    }

    private ApiMethodDoc getApiMethodDoc(Method method, Class<?> controller, JSONDoc.MethodDisplay displayMethodAs) {
        ApiMethodDoc apiMethodDoc = this.initApiMethodDoc(method, this.jsondocTemplates);
        apiMethodDoc.setDisplayMethodAs(displayMethodAs);
        apiMethodDoc.setApierrors(JSONDocApiErrorDocBuilder.build(method));
        apiMethodDoc.setSupportedversions(JSONDocApiVersionDocBuilder.build(method));
        apiMethodDoc.setAuth(JSONDocApiAuthDocBuilder.getApiAuthDocForMethod(method));
        apiMethodDoc = this.mergeApiMethodDoc(method, apiMethodDoc);
        apiMethodDoc = JSONDocApiMethodDocValidator.validateApiMethodDoc(apiMethodDoc, displayMethodAs);
        return apiMethodDoc;
    }

    @Override
    public Set<ApiFlowDoc> getApiFlowDocs(Set<Class<?>> classes, List<ApiMethodDoc> apiMethodDocs) {
        TreeSet<ApiFlowDoc> apiFlowDocs = new TreeSet<ApiFlowDoc>();
        for (Class<?> clazz : classes) {
            Method[] methods;
            log.debug("Getting JSONDoc for class: " + clazz.getName());
            for (Method method : methods = clazz.getMethods()) {
                if (!method.isAnnotationPresent(ApiFlow.class)) continue;
                ApiFlowDoc apiFlowDoc = this.getApiFlowDoc(method, apiMethodDocs);
                apiFlowDocs.add(apiFlowDoc);
            }
        }
        return apiFlowDocs;
    }

    private ApiFlowDoc getApiFlowDoc(Method method, List<ApiMethodDoc> apiMethodDocs) {
        ApiFlowDoc apiFlowDoc = ApiFlowDoc.buildFromAnnotation(method.getAnnotation(ApiFlow.class), apiMethodDocs);
        return apiFlowDoc;
    }

    @Override
    public Set<ApiObjectDoc> getApiObjectDocs(Set<Class<?>> classes) {
        TreeSet<ApiObjectDoc> apiObjectDocs = new TreeSet<ApiObjectDoc>();
        for (Class<?> clazz : classes) {
            log.debug("Getting JSONDoc for class: " + clazz.getName());
            ApiObjectDoc apiObjectDoc = this.initApiObjectDoc(clazz);
            apiObjectDoc.setSupportedversions(JSONDocApiVersionDocBuilder.build(clazz));
            apiObjectDoc = this.mergeApiObjectDoc(clazz, apiObjectDoc);
            if (apiObjectDoc.isShow()) {
                apiObjectDoc = JSONDocApiObjectDocValidator.validateApiObjectDoc(apiObjectDoc);
                apiObjectDocs.add(apiObjectDoc);
            }
            apiObjectDoc.setJsondocTemplate(this.jsondocTemplates.get(clazz));
        }
        return apiObjectDocs;
    }

    public Map<String, Set<ApiDoc>> getApiDocsMap(Set<Class<?>> classes, JSONDoc.MethodDisplay displayMethodAs) {
        TreeMap<String, Set<ApiDoc>> apiDocsMap = new TreeMap<String, Set<ApiDoc>>();
        Set<ApiDoc> apiDocSet = this.getApiDocs(classes, displayMethodAs);
        for (ApiDoc apiDoc : apiDocSet) {
            if (apiDocsMap.containsKey(apiDoc.getGroup())) {
                ((Set)apiDocsMap.get(apiDoc.getGroup())).add(apiDoc);
                continue;
            }
            TreeSet<ApiDoc> groupedPojoDocs = new TreeSet<ApiDoc>();
            groupedPojoDocs.add(apiDoc);
            apiDocsMap.put(apiDoc.getGroup(), groupedPojoDocs);
        }
        return apiDocsMap;
    }

    public Map<String, Set<ApiObjectDoc>> getApiObjectsMap(Set<Class<?>> classes) {
        TreeMap<String, Set<ApiObjectDoc>> objectsMap = new TreeMap<String, Set<ApiObjectDoc>>();
        Set<ApiObjectDoc> apiObjectDocSet = this.getApiObjectDocs(classes);
        for (ApiObjectDoc apiObjectDoc : apiObjectDocSet) {
            if (objectsMap.containsKey(apiObjectDoc.getGroup())) {
                ((Set)objectsMap.get(apiObjectDoc.getGroup())).add(apiObjectDoc);
                continue;
            }
            TreeSet<ApiObjectDoc> groupedPojoDocs = new TreeSet<ApiObjectDoc>();
            groupedPojoDocs.add(apiObjectDoc);
            objectsMap.put(apiObjectDoc.getGroup(), groupedPojoDocs);
        }
        return objectsMap;
    }

    public Map<String, Set<ApiFlowDoc>> getApiFlowDocsMap(Set<Class<?>> classes, List<ApiMethodDoc> apiMethodDocs) {
        TreeMap<String, Set<ApiFlowDoc>> apiFlowDocsMap = new TreeMap<String, Set<ApiFlowDoc>>();
        Set<ApiFlowDoc> apiFlowDocSet = this.getApiFlowDocs(classes, apiMethodDocs);
        for (ApiFlowDoc apiFlowDoc : apiFlowDocSet) {
            if (apiFlowDocsMap.containsKey(apiFlowDoc.getGroup())) {
                ((Set)apiFlowDocsMap.get(apiFlowDoc.getGroup())).add(apiFlowDoc);
                continue;
            }
            TreeSet<ApiFlowDoc> groupedFlowDocs = new TreeSet<ApiFlowDoc>();
            groupedFlowDocs.add(apiFlowDoc);
            apiFlowDocsMap.put(apiFlowDoc.getGroup(), groupedFlowDocs);
        }
        return apiFlowDocsMap;
    }

    public static String[] enumConstantsToStringArray(Object[] enumConstants) {
        String[] sarr = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            sarr[i] = String.valueOf(enumConstants[i]);
        }
        return sarr;
    }
}

