/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.scanner.validator;

import com.google.common.collect.Sets;
import org.jsondoc.core.pojo.ApiHeaderDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiParamDoc;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.core.pojo.JSONDoc;

public class JSONDocApiMethodDocValidator {
    public static ApiMethodDoc validateApiMethodDoc(ApiMethodDoc apiMethodDoc, JSONDoc.MethodDisplay displayMethodAs) {
        String ERROR_MISSING_METHOD_PATH = "Missing documentation data: path";
        String ERROR_MISSING_PATH_PARAM_NAME = "Missing documentation data: path parameter name";
        String ERROR_MISSING_QUERY_PARAM_NAME = "Missing documentation data: query parameter name";
        String ERROR_MISSING_HEADER_NAME = "Missing documentation data: header name";
        String WARN_MISSING_METHOD_PRODUCES = "Missing documentation data: produces";
        String WARN_MISSING_METHOD_CONSUMES = "Missing documentation data: consumes";
        String HINT_MISSING_PATH_PARAM_DESCRIPTION = "Add description to ApiPathParam";
        String HINT_MISSING_QUERY_PARAM_DESCRIPTION = "Add description to ApiQueryParam";
        String HINT_MISSING_METHOD_DESCRIPTION = "Add description to ApiMethod";
        String HINT_MISSING_METHOD_RESPONSE_OBJECT = "Add annotation ApiResponseObject to document the returned object";
        String HINT_MISSING_METHOD_SUMMARY = "Method display set to SUMMARY, but summary info has not been specified";
        String MESSAGE_MISSING_METHOD_SUMMARY = "Missing documentation data: summary";
        if (apiMethodDoc.getPath().isEmpty()) {
            apiMethodDoc.setPath(Sets.newHashSet((Object[])new String[]{"Missing documentation data: path"}));
            apiMethodDoc.addJsondocerror("Missing documentation data: path");
        }
        if (apiMethodDoc.getSummary().trim().isEmpty() && displayMethodAs.equals((Object)JSONDoc.MethodDisplay.SUMMARY)) {
            apiMethodDoc.setSummary("Missing documentation data: summary");
            apiMethodDoc.addJsondochint("Method display set to SUMMARY, but summary info has not been specified");
        }
        for (ApiParamDoc apiParamDoc : apiMethodDoc.getPathparameters()) {
            if (apiParamDoc.getName().trim().isEmpty()) {
                apiMethodDoc.addJsondocerror("Missing documentation data: path parameter name");
            }
            if (!apiParamDoc.getDescription().trim().isEmpty()) continue;
            apiMethodDoc.addJsondochint("Add description to ApiPathParam");
        }
        for (ApiParamDoc apiParamDoc : apiMethodDoc.getQueryparameters()) {
            if (apiParamDoc.getName().trim().isEmpty()) {
                apiMethodDoc.addJsondocerror("Missing documentation data: query parameter name");
            }
            if (!apiParamDoc.getDescription().trim().isEmpty()) continue;
            apiMethodDoc.addJsondochint("Add description to ApiQueryParam");
        }
        for (ApiHeaderDoc apiHeaderDoc : apiMethodDoc.getHeaders()) {
            if (!apiHeaderDoc.getName().trim().isEmpty()) continue;
            apiMethodDoc.addJsondocerror("Missing documentation data: header name");
        }
        if (apiMethodDoc.getProduces().isEmpty()) {
            apiMethodDoc.addJsondocwarning("Missing documentation data: produces");
        }
        if ((apiMethodDoc.getVerb().contains((Object)ApiVerb.POST) || apiMethodDoc.getVerb().contains((Object)ApiVerb.PUT)) && apiMethodDoc.getConsumes().isEmpty()) {
            apiMethodDoc.addJsondocwarning("Missing documentation data: consumes");
        }
        if (apiMethodDoc.getDescription().trim().isEmpty()) {
            apiMethodDoc.addJsondochint("Add description to ApiMethod");
        }
        if (apiMethodDoc.getResponse() == null) {
            apiMethodDoc.addJsondochint("Add annotation ApiResponseObject to document the returned object");
        }
        return apiMethodDoc;
    }
}

