/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.sample.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiBodyObject;
import org.jsondoc.core.annotation.ApiError;
import org.jsondoc.core.annotation.ApiErrors;
import org.jsondoc.core.annotation.ApiHeader;
import org.jsondoc.core.annotation.ApiHeaders;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.jsondoc.core.annotation.ApiVersion;
import org.jsondoc.core.pojo.ApiParamType;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.sample.pojo.City;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(name="city services", description="Methods for managing cities", group="Geography")
@Controller
@ApiVersion(since="1.0")
@RequestMapping(value={"/cities"})
public class CityController {
    @ApiMethod(path="/cities/name/{name}", verb=ApiVerb.GET, description="Gets a city with the given name. (Allowed values are just to demonstrate the annotation attribute)", produces={"application/json", "application/xml"})
    @ApiVersion(since="1.0", until="2.12")
    @ApiErrors(apierrors={@ApiError(code="2000", description="City not found"), @ApiError(code="9000", description="Illegal argument")})
    @RequestMapping(value={"/name/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public City get(@PathVariable @ApiParam(name="name", description="The city name", allowedvalues={"Melbourne", "Sydney", "Perth"}, paramType=ApiParamType.PATH) String name) {
        return new City(name, Integer.valueOf(1982700), Integer.valueOf(52));
    }

    @ApiMethod(path="/cities", verb=ApiVerb.POST, description="Saves a city", produces={"application/json", "application/xml"}, consumes={"application/json", "application/xml"})
    @ApiVersion(since="1.2-SNAPSHOT")
    @ApiHeaders(headers={@ApiHeader(name="api_id", description="The api identifier")})
    @ApiErrors(apierrors={@ApiError(code="3000", description="City already existing"), @ApiError(code="9000", description="Illegal argument")})
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    @ApiResponseObject
    public City post(@RequestBody @ApiBodyObject City city) {
        return city;
    }

    @ApiMethod(path="/cities/{id}", verb=ApiVerb.DELETE, description="Deleted a city by its ID")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable @ApiParam(name="id", description="The city ID", paramType=ApiParamType.PATH) Integer id) {
    }

    @ApiMethod(path="/cities/{id}", verb=ApiVerb.GET, description="Gets a city by its ID", produces={"application/json"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ApiResponseObject
    public City getById(@PathVariable @ApiParam(name="id", description="The city ID", paramType=ApiParamType.PATH) Integer id) {
        return new City("cityById", Integer.valueOf(1982700), Integer.valueOf(52));
    }

    @ApiMethod(path="/cities/{id}", verb=ApiVerb.PUT, description="Modifies a city", produces={"application/json", "application/xml"}, consumes={"application/json"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    @ApiResponseObject
    public City put(@PathVariable @ApiParam(name="id", description="The city ID", paramType=ApiParamType.PATH) Integer id, @RequestBody @ApiBodyObject City city) {
        return city;
    }

    @ApiMethod(path="/cities/map", verb=ApiVerb.GET, description="Gets a map of cities", produces={"application/json"})
    @RequestMapping(value={"/map"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponseObject
    @ResponseBody
    public Map<String, City> map() {
        HashMap<String, City> cities = new HashMap<String, City>();
        cities.put("a", new City("Adelaide", Integer.valueOf(4322), Integer.valueOf(8)));
        cities.put("m", new City("Melbourne", Integer.valueOf(9080), Integer.valueOf(12)));
        cities.put("p", new City("Perth", Integer.valueOf(743534), Integer.valueOf(5)));
        cities.put("s", new City("Sydney", Integer.valueOf(54654), Integer.valueOf(32)));
        return cities;
    }

    @ApiMethod(path="/cities/map/list", verb=ApiVerb.GET, description="Gets a map of list of cities", produces={"application/json"})
    @RequestMapping(value={"/map/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponseObject
    @ResponseBody
    public Map<List<String>, City> mapList() {
        HashMap<List<String>, City> cities = new HashMap<List<String>, City>();
        ArrayList<String> a = new ArrayList<String>();
        a.add("a1");
        a.add("a2");
        ArrayList<String> m = new ArrayList<String>();
        m.add("m1");
        ArrayList<String> p = new ArrayList<String>();
        p.add("p1");
        ArrayList<String> s = new ArrayList<String>();
        s.add("s1");
        s.add("s2");
        s.add("s3");
        cities.put(a, new City("Adelaide", Integer.valueOf(4322), Integer.valueOf(8)));
        cities.put(m, new City("Melbourne", Integer.valueOf(9080), Integer.valueOf(12)));
        cities.put(p, new City("Perth", Integer.valueOf(743534), Integer.valueOf(5)));
        cities.put(s, new City("Sydney", Integer.valueOf(54654), Integer.valueOf(32)));
        return cities;
    }
}

