/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.sample.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.sample.pojo.User;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(name="type services", description="Methods for testing correct response/body/param types")
@Controller
@RequestMapping(value={"/type"})
public class TypeController {
    @ApiMethod(path="/type/string", verb=ApiVerb.GET, description="Gets a string", produces={"application/json"})
    @RequestMapping(value={"/string"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public String string() {
        return "ok";
    }

    @ApiMethod(path="/type/integer", verb=ApiVerb.GET, description="Gets an integer", produces={"application/json"})
    @RequestMapping(value={"/integer"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public Integer integer() {
        return 1;
    }

    @ApiMethod(path="/type/list/string", verb=ApiVerb.GET, description="Gets a list of string", produces={"application/json"})
    @RequestMapping(value={"/list/string"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public List<String> listOfString() {
        return new ArrayList<String>();
    }

    @ApiMethod(path="/type/list/set/long", verb=ApiVerb.GET, description="Gets a list of set of long", produces={"application/json"})
    @RequestMapping(value={"/list/set/long"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public List<Set<Long>> listOfSetOfLong() {
        return Lists.newArrayList();
    }

    @ApiMethod(path="/type/array/user", verb=ApiVerb.GET, description="Gets an array of user", produces={"application/json"})
    @RequestMapping(value={"/array/user"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public User[] arrayOfUser() {
        return new User[0];
    }

    @ApiMethod(path="/type/array/byte", verb=ApiVerb.GET, description="Gets an array of byte", produces={"application/json"})
    @RequestMapping(value={"/array/byte"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public byte[] arrayOfByte() {
        return new byte[0];
    }

    @ApiMethod(path="/type/map/string/integer", verb=ApiVerb.GET, description="Gets a map where key is string and value is integer", produces={"application/json"})
    @RequestMapping(value={"/map/string/integer"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public Map<String, Integer> mapStringInteger() {
        return Maps.newHashMap();
    }

    @ApiMethod(path="/type/map/list/string/integer", verb=ApiVerb.GET, description="Gets a map where key is a list of string and value is an integer", produces={"application/json"})
    @RequestMapping(value={"/map/list/string/integer"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiResponseObject
    public Map<List<String>, Integer> mapListOfStringInteger() {
        return Maps.newHashMap();
    }
}

