/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.extra.apachehttpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SslContextedSecureProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext sslContext;
    private boolean verifyHostname = true;

    public SslContextedSecureProtocolSocketFactory(SSLContext sslContext, boolean verifyHostname) {
        this.sslContext = sslContext;
        this.verifyHostname = verifyHostname;
    }

    public SslContextedSecureProtocolSocketFactory(SSLContext sslContext) {
        this(sslContext, true);
    }

    public SslContextedSecureProtocolSocketFactory(boolean verifyHostname) {
        this(null, verifyHostname);
    }

    public SslContextedSecureProtocolSocketFactory() {
        this(null, true);
    }

    public synchronized void setHostnameVerification(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    public synchronized boolean getHostnameVerification() {
        return this.verifyHostname;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSslSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port, clientHost, clientPort);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        Socket socket = null;
        SSLSocketFactory socketfactory = this.getSslSocketFactory();
        if (timeout == 0) {
            socket = socketfactory.createSocket(host, port, localAddress, localPort);
        } else {
            socket = socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
        }
        this.verifyHostname((SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSslSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory sf = this.getSslSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(socket, host, port, autoClose);
        this.verifyHostname(sslSocket);
        return sslSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyHostname(SSLSocket socket) throws SSLPeerUnverifiedException, UnknownHostException {
        SslContextedSecureProtocolSocketFactory sslContextedSecureProtocolSocketFactory = this;
        synchronized (sslContextedSecureProtocolSocketFactory) {
            if (!this.verifyHostname) {
                return;
            }
        }
        SSLSession session = socket.getSession();
        String hostname = session.getPeerHost();
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("Could not resolve SSL sessions server hostname: " + hostname);
        }
        X509Certificate[] certs = (X509Certificate[])session.getPeerCertificates();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found!");
        }
        X500Principal subjectDN = certs[0].getSubjectX500Principal();
        List<String> cns = this.getCNs(subjectDN);
        boolean foundHostName = false;
        for (String cn : cns) {
            if (!hostname.equalsIgnoreCase(cn)) continue;
            foundHostName = true;
            break;
        }
        if (!foundHostName) {
            throw new SSLPeerUnverifiedException("HTTPS hostname invalid: expected '" + hostname + "', received '" + cns + "'");
        }
    }

    private List<String> getCNs(X500Principal subjectDN) {
        ArrayList<String> cns = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(subjectDN.getName(), ",");
        while (st.hasMoreTokens()) {
            String cnField = st.nextToken();
            if (!cnField.startsWith("CN=")) continue;
            cns.add(cnField.substring(3));
        }
        return cns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSslSocketFactory() {
        SSLSocketFactory sslSocketFactory = null;
        SslContextedSecureProtocolSocketFactory sslContextedSecureProtocolSocketFactory = this;
        synchronized (sslContextedSecureProtocolSocketFactory) {
            if (this.sslContext != null) {
                sslSocketFactory = this.sslContext.getSocketFactory();
            }
        }
        if (sslSocketFactory == null) {
            sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return sslSocketFactory;
    }

    public synchronized void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

