/*
 * Decompiled with CFR 0.152.
 */
package org.jtrim2.ui.concurrent.query;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jtrim2.access.AccessManager;
import org.jtrim2.access.AccessRequest;
import org.jtrim2.access.AccessResult;
import org.jtrim2.access.AccessToken;
import org.jtrim2.cancel.Cancellation;
import org.jtrim2.cancel.CancellationController;
import org.jtrim2.cancel.CancellationSource;
import org.jtrim2.cancel.CancellationToken;
import org.jtrim2.concurrent.query.AsyncDataController;
import org.jtrim2.concurrent.query.AsyncDataLink;
import org.jtrim2.concurrent.query.AsyncDataListener;
import org.jtrim2.concurrent.query.AsyncDataQuery;
import org.jtrim2.concurrent.query.AsyncDataState;
import org.jtrim2.concurrent.query.AsyncReport;
import org.jtrim2.concurrent.query.SimpleDataState;
import org.jtrim2.executor.GenericUpdateTaskExecutor;
import org.jtrim2.executor.TaskExecutor;
import org.jtrim2.executor.UpdateTaskExecutor;
import org.jtrim2.ui.concurrent.UiExecutorProvider;

public final class BackgroundDataProvider<IDType, RightType> {
    private final AccessManager<IDType, RightType> accessManager;
    private final UiExecutorProvider uiExecutorProvider;

    public BackgroundDataProvider(AccessManager<IDType, RightType> accessManager, UiExecutorProvider uiExecutorProvider) {
        this.accessManager = Objects.requireNonNull(accessManager, "accessManager");
        this.uiExecutorProvider = Objects.requireNonNull(uiExecutorProvider, "uiExecutorProvider");
    }

    public <QueryArgType, DataType> AsyncDataQuery<QueryArgType, DataType> createQuery(AccessRequest<? extends IDType, ? extends RightType> request, AsyncDataQuery<QueryArgType, DataType> wrappedQuery) {
        return new UiDataQuery<QueryArgType, DataType>(request, wrappedQuery);
    }

    public <DataType> AsyncDataLink<DataType> createLink(AccessRequest<? extends IDType, ? extends RightType> request, AsyncDataLink<DataType> wrappedLink) {
        return new UiDataLink<DataType>(request, wrappedLink);
    }

    private static <T> Consumer<T> idempotentConsumer(Consumer<T> wrapped) {
        AtomicBoolean called = new AtomicBoolean(false);
        return arg -> {
            if (called.compareAndSet(false, true)) {
                wrapped.accept(arg);
            }
        };
    }

    private static enum PredefinedState implements AsyncDataController
    {
        ACCESS_DENIED("Access Denied", 0.0);

        private final AsyncDataState state;

        private PredefinedState(String stateStr, double progress) {
            this.state = new SimpleDataState(stateStr, progress);
        }

        public void controlData(Object controlArg) {
        }

        public AsyncDataState getDataState() {
            return this.state;
        }
    }

    private class UiDataLink<DataType>
    implements AsyncDataLink<DataType> {
        private final AccessRequest<? extends IDType, ? extends RightType> request;
        private final AsyncDataLink<DataType> wrappedLink;

        public UiDataLink(AccessRequest<? extends IDType, ? extends RightType> request, AsyncDataLink<DataType> wrappedLink) {
            Objects.requireNonNull(request, "request");
            Objects.requireNonNull(wrappedLink, "wrappedLink");
            this.request = request;
            this.wrappedLink = wrappedLink;
        }

        public AsyncDataController getData(CancellationToken cancelToken, AsyncDataListener<? super DataType> dataListener) {
            Objects.requireNonNull(cancelToken, "cancelToken");
            Objects.requireNonNull(dataListener, "dataListener");
            AccessResult accessResult = BackgroundDataProvider.this.accessManager.tryGetAccess(this.request);
            if (!accessResult.isAvailable()) {
                TaskExecutor executor = BackgroundDataProvider.this.uiExecutorProvider.getSimpleExecutor(false);
                executor.execute(() -> dataListener.onDoneReceive(AsyncReport.CANCELED));
                return PredefinedState.ACCESS_DENIED;
            }
            AccessToken accessToken = accessResult.getAccessToken();
            CancellationSource cancelSource = Cancellation.createCancellationSource();
            CancellationToken childToken = Cancellation.anyToken((CancellationToken[])new CancellationToken[]{cancelSource.getToken(), cancelToken});
            Runnable cleanupTask = () -> ((AccessToken)accessToken).release();
            childToken.addCancellationListener(() -> ((AccessToken)accessToken).release());
            accessToken.addReleaseListener(() -> ((CancellationController)cancelSource.getController()).cancel());
            try {
                UiDataListener listener = new UiDataListener(dataListener, accessToken, cleanupTask);
                return this.wrappedLink.getData(childToken, (AsyncDataListener)listener);
            }
            catch (Throwable ex) {
                cleanupTask.run();
                throw ex;
            }
        }

        private class UiDataListener
        implements AsyncDataListener<DataType> {
            private final AsyncDataListener<? super DataType> dataListener;
            private final Runnable cleanupTask;
            private final TaskExecutor uiExecutor;
            private final TaskExecutor tokenExecutor;
            private final UpdateTaskExecutor dataExecutor;

            public UiDataListener(AsyncDataListener<? super DataType> dataListener, AccessToken<?> accessToken, Runnable cleanupTask) {
                this.dataListener = dataListener;
                this.uiExecutor = BackgroundDataProvider.this.uiExecutorProvider.getStrictExecutor(true);
                this.tokenExecutor = accessToken.createExecutor(this.uiExecutor);
                this.dataExecutor = new GenericUpdateTaskExecutor((Executor)this.tokenExecutor);
                this.cleanupTask = cleanupTask;
            }

            public void onDataArrive(DataType data) {
                this.dataExecutor.execute(() -> this.dataListener.onDataArrive(data));
            }

            public void onDoneReceive(AsyncReport report) {
                AtomicBoolean forwarded = new AtomicBoolean(false);
                Consumer doneForwarder = BackgroundDataProvider.idempotentConsumer(arg_0 -> this.dataListener.onDoneReceive(arg_0));
                this.tokenExecutor.execute(Cancellation.UNCANCELABLE_TOKEN, cancelToken -> {
                    doneForwarder.accept(report);
                    forwarded.set(true);
                }).whenComplete((result, error) -> {
                    try {
                        if (!forwarded.get()) {
                            BackgroundDataProvider.this.uiExecutorProvider.getSimpleExecutor(false).execute(() -> doneForwarder.accept(AsyncReport.getReport((Throwable)report.getException())));
                        }
                    }
                    finally {
                        this.cleanupTask.run();
                    }
                });
            }
        }
    }

    private class UiDataQuery<QueryArgType, DataType>
    implements AsyncDataQuery<QueryArgType, DataType> {
        private final AccessRequest<? extends IDType, ? extends RightType> request;
        private final AsyncDataQuery<QueryArgType, DataType> wrappedQuery;

        public UiDataQuery(AccessRequest<? extends IDType, ? extends RightType> request, AsyncDataQuery<QueryArgType, DataType> wrappedQuery) {
            Objects.requireNonNull(request, "request");
            Objects.requireNonNull(wrappedQuery, "wrappedQuery");
            this.request = request;
            this.wrappedQuery = wrappedQuery;
        }

        public AsyncDataLink<DataType> createDataLink(QueryArgType arg) {
            return BackgroundDataProvider.this.createLink(this.request, this.wrappedQuery.createDataLink(arg));
        }
    }
}

