/*
 * Decompiled with CFR 0.152.
 */
package org.jtrim2.ui.concurrent.query;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtrim2.cancel.Cancellation;
import org.jtrim2.cancel.CancellationController;
import org.jtrim2.cancel.CancellationSource;
import org.jtrim2.cancel.CancellationToken;
import org.jtrim2.concurrent.AsyncTasks;
import org.jtrim2.concurrent.Tasks;
import org.jtrim2.concurrent.query.AsyncDataController;
import org.jtrim2.concurrent.query.AsyncDataLink;
import org.jtrim2.concurrent.query.AsyncDataListener;
import org.jtrim2.concurrent.query.AsyncDataState;
import org.jtrim2.concurrent.query.AsyncHelper;
import org.jtrim2.concurrent.query.AsyncReport;
import org.jtrim2.concurrent.query.SimpleDataController;
import org.jtrim2.concurrent.query.SimpleDataState;
import org.jtrim2.event.ListenerRef;
import org.jtrim2.executor.GenericUpdateTaskExecutor;
import org.jtrim2.executor.SyncTaskExecutor;
import org.jtrim2.executor.TaskExecutor;
import org.jtrim2.executor.TaskExecutors;
import org.jtrim2.executor.UpdateTaskExecutor;
import org.jtrim2.ui.concurrent.query.AsyncRenderer;
import org.jtrim2.ui.concurrent.query.AsyncRendererFactory;
import org.jtrim2.ui.concurrent.query.DataRenderer;
import org.jtrim2.ui.concurrent.query.RenderingState;

public final class GenericAsyncRendererFactory
implements AsyncRendererFactory {
    private static final Logger LOGGER = Logger.getLogger(GenericAsyncRendererFactory.class.getName());
    private static final AsyncDataState NOT_STARTED_STATE = new SimpleDataState("Data receiving has not yet been started.", 0.0);
    private static final RenderTask<?> POISON_RENDER_TASK = new RenderTask<Object>(new GenericAsyncRenderer(SyncTaskExecutor.getSimpleExecutor()), Cancellation.CANCELED_TOKEN, GenericAsyncRendererFactory.dummyDataLink(), DummyRenderer.INSTANCE);
    private final TaskExecutor executor;

    public GenericAsyncRendererFactory(TaskExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        this.executor = executor;
    }

    @Override
    public AsyncRenderer createRenderer() {
        return new GenericAsyncRenderer(this.executor);
    }

    private static <DataType> AsyncDataLink<DataType> dummyDataLink() {
        return (cancelToken, dataListener) -> {
            dataListener.onDoneReceive(AsyncReport.SUCCESS);
            return new SimpleDataController((AsyncDataState)new SimpleDataState("", 1.0));
        };
    }

    private static enum DummyRenderer implements DataRenderer<Object>
    {
        INSTANCE;


        @Override
        public boolean startRendering(CancellationToken cancelToken) {
            return true;
        }

        @Override
        public boolean willDoSignificantRender(Object data) {
            return true;
        }

        @Override
        public boolean render(CancellationToken cancelToken, Object data) {
            return true;
        }

        @Override
        public void finishRendering(CancellationToken cancelToken, AsyncReport report) {
        }
    }

    private static class MultiTask
    implements Runnable {
        private final Runnable task1;
        private final Runnable task2;

        public MultiTask(Runnable task1, Runnable task2) {
            assert (task1 != null);
            assert (task2 != null);
            this.task1 = task1;
            this.task2 = task2;
        }

        @Override
        public void run() {
            try {
                this.task1.run();
            }
            finally {
                this.task2.run();
            }
        }
    }

    private static class RenderTask<DataType>
    implements RenderingState {
        private final GenericAsyncRenderer asyncRenderer;
        private final CancellationController cancelController;
        private final CancellationToken cancelToken;
        private final AsyncDataLink<DataType> dataLink;
        private final DataRenderer<? super DataType> renderer;
        private final TaskExecutor rendererExecutor;
        private final UpdateTaskExecutor dataExecutor;
        private final AtomicReference<Runnable> onFinishTaskRef;
        private final AtomicReference<RenderTask<?>> nextTaskRef;
        private final long startTime;
        private volatile AsyncDataController dataController;
        private volatile boolean replacable;
        private volatile boolean finished;

        public RenderTask(GenericAsyncRenderer asyncRenderer, CancellationToken cancelToken, AsyncDataLink<DataType> dataLink, DataRenderer<? super DataType> renderer) {
            assert (asyncRenderer != null);
            assert (cancelToken != null);
            assert (dataLink != null);
            assert (renderer != null);
            CancellationSource taskCancelSource = Cancellation.createCancellationSource();
            this.cancelToken = Cancellation.anyToken((CancellationToken[])new CancellationToken[]{taskCancelSource.getToken(), cancelToken});
            this.cancelController = taskCancelSource.getController();
            this.renderer = renderer;
            this.dataLink = dataLink;
            this.asyncRenderer = asyncRenderer;
            this.startTime = System.nanoTime();
            this.finished = false;
            this.dataController = null;
            this.onFinishTaskRef = new AtomicReference<Runnable>(Tasks.noOpTask());
            this.nextTaskRef = new AtomicReference<Object>(null);
            this.rendererExecutor = TaskExecutors.inOrderExecutor((TaskExecutor)asyncRenderer.getExecutor());
            this.replacable = false;
            this.dataExecutor = new GenericUpdateTaskExecutor((Executor)this.rendererExecutor);
        }

        private boolean trySetNextTask(RenderTask<?> nextTask) {
            RenderTask<?> currentNextTask;
            do {
                if ((currentNextTask = this.nextTaskRef.get()) != POISON_RENDER_TASK) continue;
                return false;
            } while (!this.nextTaskRef.compareAndSet(currentNextTask, nextTask));
            if (currentNextTask != null) {
                super.setFinished();
            }
            if (this.replacable) {
                this.cancel();
            }
            return true;
        }

        private void addFinishTask(Runnable task) {
            MultiTask newFinishTask;
            Runnable currentFinishTask;
            do {
                if ((currentFinishTask = this.onFinishTaskRef.get()) != null) continue;
                task.run();
                return;
            } while (!this.onFinishTaskRef.compareAndSet(currentFinishTask, newFinishTask = new MultiTask(currentFinishTask, task)));
        }

        public RenderingState startTask() {
            RenderTask<?> currentTask;
            do {
                if ((currentTask = this.asyncRenderer.setTaskIf(null, this)) != null) continue;
                this.doStartTask();
                return this;
            } while (!super.trySetNextTask(this));
            return this;
        }

        private void mayFetchNextTask() {
            this.replacable = true;
            if (this.nextTaskRef.get() != null) {
                this.cancel();
            }
        }

        private void doStartTask() {
            if (this.cancelToken.isCanceled()) {
                this.completeThisTask();
                return;
            }
            this.addFinishTask(this::completeThisTask);
            final AtomicBoolean startedRendering = new AtomicBoolean(false);
            this.rendererExecutor.execute(this.cancelToken, rendererCancelToken -> {
                startedRendering.set(true);
                boolean mayReplace = this.renderer.startRendering(rendererCancelToken);
                if (mayReplace) {
                    this.mayFetchNextTask();
                }
            });
            AsyncDataListener dataListener = new AsyncDataListener<DataType>(){

                public void onDataArrive(DataType data) {
                    boolean promisedToBeSignificant;
                    if (nextTaskRef.get() != null && renderer.willDoSignificantRender(data)) {
                        this.cancel();
                        promisedToBeSignificant = true;
                    } else {
                        promisedToBeSignificant = false;
                    }
                    dataExecutor.execute(() -> {
                        if (startedRendering.get()) {
                            boolean mayReplace = renderer.render(cancelToken, data);
                            if (mayReplace) {
                                this.mayFetchNextTask();
                            } else if (promisedToBeSignificant) {
                                LOGGER.log(Level.WARNING, "willDoSignificantRender reported that the renderer will do a significant rendering but render returned false.");
                            }
                        }
                    });
                }

                public void onDoneReceive(AsyncReport report) {
                    rendererExecutor.execute(Cancellation.UNCANCELABLE_TOKEN, cancelToken -> {
                        if (startedRendering.get()) {
                            renderer.finishRendering(cancelToken, report);
                        }
                    }).whenComplete((result, error) -> {
                        Runnable finishTask = onFinishTaskRef.getAndSet(null);
                        if (finishTask != null) {
                            finishTask.run();
                        }
                    }).exceptionally(AsyncTasks::expectNoError);
                }
            };
            AsyncDataListener safeListener = AsyncHelper.makeSafeListener((AsyncDataListener)dataListener);
            ListenerRef cancelRef = this.cancelToken.addCancellationListener(() -> safeListener.onDoneReceive(AsyncReport.CANCELED));
            this.addFinishTask(() -> ((ListenerRef)cancelRef).unregister());
            this.dataController = this.dataLink.getData(this.cancelToken, safeListener);
        }

        private void setFinished() {
            this.finished = true;
        }

        private void cancel() {
            this.cancelController.cancel();
        }

        private void completeThisTask() {
            this.setFinished();
            RenderTask nextTask = this.nextTaskRef.getAndSet(POISON_RENDER_TASK);
            if (nextTask != null) {
                RenderTask<?> currentTask = this.asyncRenderer.setTask(nextTask);
                nextTask.doStartTask();
                assert (currentTask == this);
            } else {
                this.asyncRenderer.setTaskIf(this, null);
            }
        }

        @Override
        public boolean isRenderingFinished() {
            return this.finished;
        }

        @Override
        public long getRenderingTime(TimeUnit unit) {
            return unit.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
        }

        @Override
        public AsyncDataState getAsyncDataState() {
            AsyncDataController currentController = this.dataController;
            return currentController != null ? currentController.getDataState() : NOT_STARTED_STATE;
        }
    }

    private static class GenericAsyncRenderer
    implements AsyncRenderer {
        private final TaskExecutor executor;
        private final AtomicReference<RenderTask<?>> taskRef;

        public GenericAsyncRenderer(TaskExecutor executor) {
            this.executor = executor;
            this.taskRef = new AtomicReference<Object>(null);
        }

        @Override
        public <DataType> RenderingState render(CancellationToken cancelToken, AsyncDataLink<DataType> dataLink, DataRenderer<? super DataType> renderer) {
            Objects.requireNonNull(cancelToken, "cancelToken");
            Objects.requireNonNull(renderer, "renderer");
            RenderTask<DataType> task = dataLink != null ? new RenderTask<DataType>(this, cancelToken, dataLink, renderer) : new RenderTask<DataType>(this, cancelToken, GenericAsyncRendererFactory.dummyDataLink(), renderer);
            return task.startTask();
        }

        public RenderTask<?> setTask(RenderTask<?> task) {
            return this.taskRef.getAndSet(task);
        }

        public RenderTask<?> setTaskIf(RenderTask<?> expectedTask, RenderTask<?> task) {
            RenderTask<?> currentTask;
            while ((currentTask = this.taskRef.get()) == expectedTask && !this.taskRef.compareAndSet(currentTask, task)) {
            }
            return currentTask;
        }

        public TaskExecutor getExecutor() {
            return this.executor;
        }
    }
}

