package org.juhewu.core.base.constants;

import lombok.experimental.UtilityClass;

/**
 * 常量
 *
 * @author duanjw
 */
@UtilityClass
public class CoreConstants {

    /**
     * 租户id字段
     */
    public static final String DETAILS_TENANT_ID = "tenant_id";
    /**
     * 创建的租户id字段
     */
    public static final String DETAILS_CREATE_TENANT_ID = "create_tenant_id";
    /**
     * 客户端id字段
     */
    public static final String DETAILS_CLIENT_ID = "client_id";
    /**
     * code和message的分隔符
     */
    public static final String CODE_MESSAGE_SPLIT = "||";
    /**
     * code和message的分隔符的正则
     */
    public static final String CODE_MESSAGE_SPLIT_REG = "\\|\\|";

    /**
     * 数字0
     */
    public static final Integer ZERO = 0;

    /**
     * 数字1
     */
    public static final Integer ONE = 1;

    /**
     * 数字2
     */
    public static final Integer TWO = 2;
    /**
     * AES 加密
     */
    public static final String AES = "aes";

    /**
     * 请求ID
     */
    public static final String REQUEST_TRACE_ID = "traceId";
    /**
     * 请求层级ID
     */
    public static final String REQUEST_SPAN_ID = "spanId";
}
