package org.juhewu.core.base.exception;

import org.juhewu.core.base.constants.CoreConstants;

public class BusinessException extends RuntimeException {
    /**
     * 异常返回的错误码
     */
    public static final String RUNTIME_EXCEPTION_CODE = "1";

    public BusinessException(String message) {
        super(message);
    }

    /**
     * 异常，有错误码和消息
     *
     * @param code
     */
    public BusinessException(String code, String message) {
        super(code + CoreConstants.CODE_MESSAGE_SPLIT + message);
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    /**
     * 异常，错误对象
     *
     * @param codeMessage
     */
    public BusinessException(ICodeMessage codeMessage) {
        super(codeMessage.getCode() + CoreConstants.CODE_MESSAGE_SPLIT + codeMessage.getMessage());
    }

    /**
     * 获取错误码
     *
     * @return
     */
    public String getCode() {
        return RUNTIME_EXCEPTION_CODE;
    }

}
