/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db;

import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jumpmind.db.AbstractDbTest;
import org.jumpmind.db.DbTestUtils;
import org.jumpmind.db.io.DatabaseIO;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.SqlScript;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabasePlatformTest
extends AbstractDbTest {
    private static IDatabasePlatform platform;
    protected static final String SIMPLE_TABLE = "test_simple_table";
    protected static final String UPPERCASE_TABLE = "TEST_UPPERCASE_TABLE";
    protected Level originalLevel;

    @BeforeClass
    public static void setup() throws Exception {
        platform = DbTestUtils.createDatabasePlatform("root");
    }

    public void turnOnDebug() {
        Logger logger = Logger.getLogger((String)"org.jumpmind.db");
        this.originalLevel = logger.getLevel();
        logger.setLevel(Level.TRACE);
    }

    public void turnOffDebug() {
        Logger logger = Logger.getLogger((String)"org.jumpmind.db");
        logger.setLevel(this.originalLevel);
    }

    @Test
    public void testExportDefaultValueWithUnderscores() {
        Table table = new Table("TEST_DEFAULT_UNDERSCORES");
        table.addColumn(new Column("ID", true));
        table.getColumnWithName("ID").setTypeCode(4);
        table.getColumnWithName("ID").setRequired(true);
        table.addColumn(new Column("NOTES"));
        table.getColumnWithName("NOTES").setTypeCode(12);
        table.getColumnWithName("NOTES").setSize("20");
        table.getColumnWithName("NOTES").setDefaultValue("this_has_underscores");
        Table tableFromDatabase = this.dropCreateAndThenReadTable(table);
        Assert.assertEquals((Object)table.getColumnWithName("NOTES").getDefaultValue(), (Object)tableFromDatabase.getColumnWithName("NOTES").getDefaultValue());
    }

    protected Table dropCreateAndThenReadTable(Table table) {
        Database database = new Database();
        database.addTable(table);
        platform.createDatabase(database, true, false);
        return platform.getTableFromCache(table.getName(), true);
    }

    @Test
    public void testUpgradePrimaryKeyAutoIncrementFromIntToBigInt() throws Exception {
        boolean upgradeSupported;
        boolean bl = upgradeSupported = platform.getName() != "derby" && platform.getName() != "hsqldb2" && platform.getName() != "informix" && platform.getName() != "db2";
        if (upgradeSupported) {
            Table table = new Table("TEST_UPGRADE");
            table.addColumn(new Column("ID", true));
            table.getColumnWithName("ID").setTypeCode(4);
            table.getColumnWithName("ID").setAutoIncrement(true);
            table.getColumnWithName("ID").setRequired(true);
            table.addColumn(new Column("NOTES"));
            table.getColumnWithName("NOTES").setTypeCode(12);
            table.getColumnWithName("NOTES").setSize("100");
            Table tableFromDatabase = this.dropCreateAndThenReadTable(table);
            Assert.assertTrue((boolean)tableFromDatabase.getColumnWithName("ID").isPrimaryKey());
            Assert.assertNotNull((Object)tableFromDatabase);
            String insertSql = "insert into \"TEST_UPGRADE\" (\"ID\",\"NOTES\") values(null,?)";
            insertSql = insertSql.replaceAll("\"", platform.getDatabaseInfo().getDelimiterToken());
            long id1 = platform.getSqlTemplate().insertWithGeneratedKey(insertSql, "ID", this.getSequenceName(platform), new Object[]{"test"}, new int[]{12});
            table.getColumnWithName("ID").setTypeCode(-5);
            IDdlBuilder builder = platform.getDdlBuilder();
            String alterSql = builder.alterTable(tableFromDatabase, table);
            Logger logger = Logger.getLogger((String)"org.jumpmind.db");
            logger.info((Object)alterSql);
            Assert.assertFalse((String)alterSql, (boolean)alterSql.toLowerCase().contains("create table"));
            new SqlScript(alterSql, platform.getSqlTemplate(), true).execute(true);
            tableFromDatabase = platform.getTableFromCache(table.getName(), true);
            Assert.assertEquals((long)-5L, (long)table.getColumnWithName("ID").getMappedTypeCode());
            Assert.assertTrue((boolean)tableFromDatabase.getColumnWithName("ID").isPrimaryKey());
            long id2 = platform.getSqlTemplate().insertWithGeneratedKey(insertSql, "ID", this.getSequenceName(platform), new Object[]{"test"}, new int[]{12});
            Assert.assertNotSame((Object)id1, (Object)id2);
        }
    }

    protected String getSequenceName(IDatabasePlatform platform) {
        if (platform.getName().equals("oracle")) {
            return "TEST_UPGRADE_ID";
        }
        if (platform.getName().equals("interbase")) {
            return "SEQ_TEST_UPGRADE_ID";
        }
        return "test_upgrade_id";
    }

    @Test
    public void testCreateAndReadTestSimpleTable() throws Exception {
        platform.createDatabase(new DatabaseIO().read((Reader)new InputStreamReader(DatabasePlatformTest.class.getResourceAsStream("/testCreateDatabase.xml"))), true, false);
        Table table = platform.getTableFromCache(SIMPLE_TABLE, true);
        Assert.assertNotNull((String)"Could not find test_simple_table", (Object)table);
        Assert.assertEquals((String)"The id column was not read in as an autoincrement column", (Object)true, (Object)table.getColumnWithName("id").isAutoIncrement());
    }

    @Test
    public void testReadTestUppercase() throws Exception {
        Table table = platform.getTableFromCache(UPPERCASE_TABLE, true);
        Assert.assertNotNull((String)"Could not find TEST_UPPERCASE_TABLE", (Object)table);
        Assert.assertEquals((String)"The id column was not read in as an autoincrement column", (Object)true, (Object)table.getColumnWithName("id").isAutoIncrement());
    }
}

