/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db;

import java.io.File;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.jumpmind.db.DatabasePlatformTest;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.DataSourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbTestUtils {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DB_TEST_PROPERTIES = "/db-test.properties";
    public static final String ROOT = "root";
    public static final String CLIENT = "client";

    public static IDatabasePlatform createDatabasePlatform(String name) throws Exception {
        FileUtils.deleteDirectory((File)new File(String.format("target/%sdbs", name)));
        DataSourceProperties properties = new DataSourceProperties(String.format("test.%s", name), DatabasePlatformTest.class.getResource(DB_TEST_PROPERTIES), new String[]{name});
        return JdbcDatabasePlatformFactory.createNewPlatformInstance((DataSource)properties.getDataSource(), (SqlTemplateSettings)new SqlTemplateSettings(), (boolean)true);
    }
}

