/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.junit.Test;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqlScriptUnitTest {
    @Test
    public void testSimpleSqlScript() throws Exception {
        SingleConnectionDataSource ds = this.getDataSource();
        IDatabasePlatform platform = JdbcDatabasePlatformFactory.createNewPlatformInstance((DataSource)ds, (SqlTemplateSettings)new SqlTemplateSettings(), (boolean)true);
        SqlScript script = new SqlScript(this.getClass().getResource("sqlscript-simple.sql"), platform.getSqlTemplate());
        script.execute();
        JdbcTemplate template = new JdbcTemplate((DataSource)ds);
        Assert.assertEquals((int)2, (int)template.queryForInt("select count(*) from test"));
        Assert.assertEquals((int)3, (int)((String)template.queryForObject("select test from test where test_id=2", String.class)).split("\r\n|\r|\n").length);
        ds.destroy();
    }

    private SingleConnectionDataSource getDataSource() throws Exception {
        Class.forName("org.h2.Driver");
        Connection c = DriverManager.getConnection("jdbc:h2:mem:sqlscript");
        return new SingleConnectionDataSource(c, true);
    }
}

