/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db;

import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Level;
import org.jumpmind.db.DbTestUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDdlTypesTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static IDatabasePlatform platform;
    protected Level originalLevel;

    @BeforeClass
    public static void setup() throws Exception {
        platform = DbTestUtils.createDatabasePlatform("root");
    }

    protected abstract String getName();

    protected abstract String[] getDdlTypes();

    @Before
    public void checkDatabaseType() {
        Assume.assumeTrue((boolean)platform.getName().equals(this.getName()));
    }

    @Test
    public void testPlatformSpecificDdl() throws Exception {
        Column[] columns1;
        this.dropTable();
        this.createTable();
        Table fromDb1 = platform.readTableFromDatabase(null, null, this.tableName());
        Assert.assertNotNull((Object)fromDb1);
        this.dropTable();
        for (Column column : columns1 = fromDb1.getColumns()) {
            Assert.assertNotNull((Object)column.findPlatformColumn(this.getName()));
        }
        String xml = DatabaseXmlUtil.toXml((Table)fromDb1);
        this.log.info("XML generated for table:\n" + xml);
        StringReader reader = new StringReader(xml);
        Table fromXml = DatabaseXmlUtil.read((Reader)reader, (boolean)false).getTable(0);
        for (Column column : fromXml.getColumns()) {
            Assert.assertNotNull((String)("Expected " + this.getName() + " platform specific column information for " + column.getName()), (Object)column.findPlatformColumn(this.getName()));
        }
        Assert.assertNotNull((Object)fromXml);
        platform.alterTables(false, new Table[]{fromXml});
        Table fromDb2 = platform.readTableFromDatabase(null, null, this.tableName());
        Assert.assertNotNull((String)("Could not find " + this.tableName() + " in the database"), (Object)fromDb2);
        for (Column column1 : columns1) {
            PlatformColumn pColumn1 = column1.findPlatformColumn(this.getName());
            Column column2 = fromDb2.findColumn(column1.getName());
            Assert.assertNotNull((Object)column2);
            PlatformColumn pColumn2 = column2.findPlatformColumn(this.getName());
            Assert.assertNotNull((Object)pColumn2);
            Assert.assertEquals((Object)pColumn1.getType(), (Object)pColumn2.getType());
            Assert.assertEquals((long)pColumn1.getSize(), (long)pColumn2.getSize());
            Assert.assertEquals((long)pColumn1.getDecimalDigits(), (long)pColumn2.getDecimalDigits());
        }
    }

    protected void createTable() {
        ISqlTemplate sqlTemplate = platform.getSqlTemplate();
        sqlTemplate.update(this.buildDdl(), new Object[0]);
    }

    protected void dropTable() {
        Table table = platform.readTableFromDatabase(null, null, this.tableName());
        if (table != null) {
            platform.dropTables(true, new Table[]{table});
        }
    }

    protected String tableName() {
        return platform.alterCaseToMatchDatabaseDefaultCase("test_types");
    }

    protected String buildDdl() {
        StringBuilder ddl = new StringBuilder();
        String[] colTypes = this.getDdlTypes();
        ddl.append("CREATE TABLE ").append(this.tableName()).append(" (");
        for (int i = 0; i < colTypes.length; ++i) {
            ddl.append(platform.alterCaseToMatchDatabaseDefaultCase("col")).append(i).append(" ").append(colTypes[i]).append(",");
        }
        ddl.replace(ddl.length() - 1, ddl.length(), ")");
        return ddl.toString();
    }
}

