/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db;

import java.io.File;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.jumpmind.db.DatabasePlatformTest;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.util.BasicDataSourceFactory;
import org.jumpmind.properties.EnvironmentSpecificProperties;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbTestUtils {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DB_TEST_PROPERTIES = "/db-test.properties";
    public static final String ROOT = "root";
    public static final String CLIENT = "client";

    public static EnvironmentSpecificProperties getEnvironmentSpecificProperties(String name) {
        return new EnvironmentSpecificProperties(DatabasePlatformTest.class.getResource(DB_TEST_PROPERTIES), String.format("test.%s", name), new String[]{name});
    }

    public static IDatabasePlatform createDatabasePlatform(String name) throws Exception {
        File f = new File(String.format("target/%sdbs", name));
        FileUtils.deleteDirectory((File)f);
        f.mkdir();
        EnvironmentSpecificProperties properties = DbTestUtils.getEnvironmentSpecificProperties(name);
        return JdbcDatabasePlatformFactory.createNewPlatformInstance((DataSource)BasicDataSourceFactory.create((TypedProperties)properties, (ISecurityService)SecurityServiceFactory.create()), (SqlTemplateSettings)new SqlTemplateSettings(), (boolean)true);
    }
}

