/*
 * Decompiled with CFR 0.152.
 */
package org.jupiter.benchmark.tcp;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.jupiter.benchmark.tcp.Service;
import org.jupiter.common.util.Lists;
import org.jupiter.common.util.SystemPropertyUtil;
import org.jupiter.common.util.internal.logging.InternalLogger;
import org.jupiter.common.util.internal.logging.InternalLoggerFactory;
import org.jupiter.rpc.DefaultClient;
import org.jupiter.rpc.InvokeType;
import org.jupiter.rpc.JClient;
import org.jupiter.rpc.consumer.ProxyFactory;
import org.jupiter.rpc.consumer.future.InvokeFuture;
import org.jupiter.rpc.consumer.future.InvokeFutureContext;
import org.jupiter.rpc.load.balance.LoadBalancerType;
import org.jupiter.serialization.SerializerType;
import org.jupiter.transport.JConnector;
import org.jupiter.transport.JOption;
import org.jupiter.transport.UnresolvedAddress;
import org.jupiter.transport.netty.JNettyTcpConnector;

public class BenchmarkClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BenchmarkClient.class);

    public static void main(String[] args) {
        int processors = Runtime.getRuntime().availableProcessors();
        SystemPropertyUtil.setProperty((String)"jupiter.executor.factory.consumer.core.workers", (String)String.valueOf(processors));
        SystemPropertyUtil.setProperty((String)"jupiter.tracing.needed", (String)"false");
        SystemPropertyUtil.setProperty((String)"jupiter.use.non_blocking_hash", (String)"true");
        JClient client = new DefaultClient().withConnector((JConnector)new JNettyTcpConnector(processors + 1));
        client.connector().config().setOption(JOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)262144);
        client.connector().config().setOption(JOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)131072);
        UnresolvedAddress[] addresses = new UnresolvedAddress[processors];
        for (int i = 0; i < processors; ++i) {
            addresses[i] = new UnresolvedAddress("127.0.0.1", 18099);
            client.connector().connect(addresses[i]);
        }
        if (SystemPropertyUtil.getBoolean((String)"jupiter.test.async", (boolean)true)) {
            BenchmarkClient.futureCall(client, addresses, processors);
        } else {
            BenchmarkClient.syncCall(client, addresses, processors);
        }
    }

    private static void syncCall(JClient client, UnresolvedAddress[] addresses, int processors) {
        final Service service = (Service)ProxyFactory.factory(Service.class).version("1.0.0").client(client).loadBalancerType(LoadBalancerType.ROUND_ROBIN).addProviderAddress(addresses).newProxyInstance();
        for (int i = 0; i < 10000; ++i) {
            try {
                service.hello("jupiter");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int t = 500000;
        int step = 6;
        long start = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(processors << 6);
        final AtomicLong count = new AtomicLong();
        for (int i = 0; i < processors << 6; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 500000; ++i) {
                        try {
                            service.hello("jupiter");
                            if (count.getAndIncrement() % 10000L != 0L) continue;
                            logger.warn("count=" + count.get());
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    latch.countDown();
                }
            }).start();
        }
        try {
            latch.await();
            logger.warn("count=" + count.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long second = (System.currentTimeMillis() - start) / 1000L;
        logger.warn("Request count: " + count.get() + ", time: " + second + " second, qps: " + count.get() / second);
    }

    private static void futureCall(JClient client, UnresolvedAddress[] addresses, int processors) {
        final Service service = (Service)ProxyFactory.factory(Service.class).version("1.0.0").client(client).invokeType(InvokeType.ASYNC).serializerType(SerializerType.KRYO).loadBalancerType(LoadBalancerType.ROUND_ROBIN).addProviderAddress(addresses).newProxyInstance();
        for (int i = 0; i < 10000; ++i) {
            try {
                service.hello("jupiter");
                InvokeFutureContext.future().getResult();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        int t = 80000;
        long start = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(processors << 4);
        final AtomicLong count = new AtomicLong();
        int futureSize = 80;
        for (int i = 0; i < processors << 4; ++i) {
            new Thread(new Runnable(){
                List<InvokeFuture<?>> futures = Lists.newArrayListWithCapacity((int)80);

                @Override
                public void run() {
                    for (int i = 0; i < 80000; ++i) {
                        try {
                            service.hello("jupiter");
                            this.futures.add(InvokeFutureContext.future());
                            if (this.futures.size() == 80) {
                                int fSize = this.futures.size();
                                for (int j = 0; j < fSize; ++j) {
                                    try {
                                        this.futures.get(j).getResult();
                                        continue;
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                }
                                this.futures.clear();
                            }
                            if (count.getAndIncrement() % 10000L != 0L) continue;
                            logger.warn("count=" + count.get());
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!this.futures.isEmpty()) {
                        int fSize = this.futures.size();
                        for (int j = 0; j < fSize; ++j) {
                            try {
                                this.futures.get(j).getResult();
                                continue;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        this.futures.clear();
                    }
                    latch.countDown();
                }
            }).start();
        }
        try {
            latch.await();
            logger.warn("count=" + count.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long second = (System.currentTimeMillis() - start) / 1000L;
        logger.warn("Request count: " + count.get() + ", time: " + second + " second, qps: " + count.get() / second);
    }
}

